#
# (C) 2003 Tenable Network Security
#
# Redistribution and use in source, with or without modification, are 
# permitted provided that the following conditions are met:
#
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. All advertising materials mentioning features or use of this software
#    must display the following acknowledgement:
#     This product includes software developed by Tenable Network Security
#
#
#
# grep ":.*:.*:.*:.*:.*:.*:.*:.*:.*:.*:" os_fingerprint.nasl | sort  | uniq -c  | sort -n
#

if (description)
{
  script_version("$Revision: 1.100 $");
  script_id(11936);

  name["english"] = "OS Identification";
  script_name(english:name["english"]);

  desc["english"] = "
This script attempts to identify the Operating System type and version by
various ways :

- If the remote host is a Windows host, it will attempt to determine its
  OS type by sending MSRPC packets on port 135 and guess the OS based on
  the results

- If the remote host has a NTP client listening on port 123, this script will
  try to ask for the operating system version this way

- Otherwise, this script determines the remote operating system by sending more 
or less incorrect ICMP requests using the techniques outlined in Ofir Arkin's 
paper 'ICMP Usage In Scanning'.

An attacker may use this to identify the kind of the remote operating
system and gain further knowledge about this host.

See also : http://www.sys-security.com/html/projects/icmp.html (icmp os identification)
Risk factor : Low";

  script_description(english:desc["english"]);
 
  summary["english"] = "Determines the remote operating system";
  script_summary(english:summary["english"]);
 
  script_category(ACT_GATHER_INFO);
 
  script_copyright(english:"This script is Copyright (C) 2003 Tenable Network Security");
  family["english"] = "General";
  script_family(english:family["english"]);
  script_dependencies("smb_nativelanman.nasl", "netbios_name_get.nasl", "smb_login.nasl","smb_registry_full_access.nasl", "ntp_open.nasl", "mdns.nasl", "snmp_sysDesc.nasl");
  script_require_ports(139, 445, "Host/scanned");
  exit(0);
}



include("network_func.inc");
include("smb_nt.inc");
include("smb_file_funcs.inc");



if ( (os = get_kb_item("mDNS/os")) )
{
         report = "The remote host is running " + os;
         set_kb_item(name:"Host/OS/icmp", value:os);
	 security_note(port:0, data:report);
	 exit(0);
}

if ( ( os = get_kb_item("SNMP/sysDesc")) ) 
{
 if ("ELSA LANCOM" >< os )
 {
   report = "The remote host is running " + os;
   set_kb_item(name:"Host/OS/icmp", value:os);
   security_note(port:0, data:report);
   exit(0);
 }
 if ("IP Console Switch " >< os )
 {
  report = "The remote host is running HP " + os;
   set_kb_item(name:"Host/OS/icmp", value:"HP " + os);
   security_note(port:0, data:report);
   exit(0);
 }
 if ("SCO UnixWare" >< os )
 {
   report = "The remote host is running " + os;
   set_kb_item(name:"Host/OS/icmp", value:os);
   security_note(port:0, data:report);
   exit(0);
 }

 if ("Apple Base Station" >< os )
 {
   version = ereg_replace(pattern:".*Apple Base Station V(.*) Compatible",
			  replace:"\1",
			  string:os);
 
   os = "Apple Airport " + version;
   report = "The remote host is running " + os;
   set_kb_item(name:"Host/OS/icmp", value:os);
   security_note(port:0, data:report);
   exit(0);
 }
 if ("OpenVMS" >< os )
 {
  version = ereg_replace(pattern:".*OpenVMS V([0-9]*\.[0-9]*).*", 
			 string:egrep(pattern:"OpenVMS", string:os),
			 replace:"\1");
  if ( version != os )
  {
   os = "OpenVMS " + version;
   report = "The remote host is running " + os;
   set_kb_item(name:"Host/OS/icmp", value:os);
   security_note(port:0, data:report);
   exit(0);
  }

   
 }
 if ("IBM Gigabit Ethernet Switch Module" >< os )
 {
   os = "IBM Gigabit Ethernet Switch Module";
   report = "The remote host is running " + os;
   set_kb_item(name:"Host/OS/icmp", value:os);
   security_note(port:0, data:report);
   exit(0);
 }
 if ( "IOS (tm)" >< os )
 {
  version = ereg_replace(pattern:".*IOS.*Version ([0-9]*\.[0-9]*)\(.*",
			 string:egrep(pattern:"IOS", string:os),
			 replace:"\1");

  if ( version != os )
  {
   os = "CISCO IOS " + version;
   report = "The remote host is running " + os;
   set_kb_item(name:"Host/OS/icmp", value:os);
   security_note(port:0, data:report);
   exit(0);
  }
 }

 if ("Digital UNIX" >< os )
 {
  version = ereg_replace(pattern:".*Digital UNIX V([0-9]\.[0-9]).*",
			 string:egrep(pattern:"Digital UNIX", string:os),
			 replace:"\1");
  if ( version != os )
  {
   os = "Digital Unix " + version;
   report = "The remote host is running " + os;
   set_kb_item(name:"Host/OS/icmp", value:os);
   security_note(port:0, data:report);
   exit(0);
  }
 }


 if ("ULTRIX" >< os )
 {
  version = ereg_replace(pattern:".*ULTRIX V([^ ]*).*", 
			 string:egrep(pattern:"ULTRIX", string:os), 
			 replace:"\1");
  if ( version != os ) 
  {
   os = "ULTRIX " + version;
   report = "The remote host is running " + os;
   set_kb_item(name:"Host/OS/icmp", value:os);
   security_note(port:0, data:report);
   exit(0);
  }
 }
 if ("HP-UX" >< os )
 {
   version = ereg_replace(pattern:".*HP-UX [^ ]* ([^ ]*) .*", 
			  replace:"\1", 
			  string:egrep(pattern:"HP-UX", string:os)
			 );
   if ( version != os )
   {
   report = "The remote host is running HP/UX " + version;
   set_kb_item(name:"Host/OS/icmp", value:"HP/UX " + version);
   security_note(port:0, data:report);
   exit(0);
   }
 }

 if ( "kernel 2." >< os )
 {
  version = ereg_replace(pattern:".* kernel (2\.[0-9])\..*", replace:"\1", string:os);
  if ( version != os ) 
  {
  version = "Linux Kernel " + version;
  report = "The remote host is running " + version;
  set_kb_item(name:"Host/OS/icmp", value:version);
  security_note(port:0, data:report);
  exit(0);
  }
 }

 if ("JETDIRECT" >< os )
 {
  version = "HP JetDirect";
  report = "The remote host is running " + version;
  set_kb_item(name:"Host/OS/icmp", value:version);
  security_note(port:0, data:report);
  exit(0);
 } 

 if ("Xerox" >< os )
 {
  version = "Xerox Printer";
  report = "The remote host is running " + version;
  set_kb_item(name:"Host/OS/icmp", value:version);
  security_note(port:0, data:report);
  exit(0);
 }

 if ("NetQue" >< os )
 {
  report = "The remote host is running NetQue Printer Server";
  set_kb_item(name:"Host/OS/icmp", value:"NetQue Printer Server");
  security_note(port:0, data:report);
  exit(0);
 }

 # http://www.dealtime.co.uk/xPF-Equinox_MDS_10_990410
 if ("EQUINOX MDS" >< os )
 {
  os = "Equinox MDS Transceiver";
  report = "The remote host is running " + os;
  set_kb_item(name:"Host/OS/icmp", value:os);
  security_note(port:0, data:report);
  exit(0);
 }

 if ("Novell NetWare" >< os )
 {
  version = ereg_replace(pattern:".* NetWare ([^ ]*).*", string:os, replace:"\1");
  if ( version != os ) 
  {
  version = split(version, sep:'.', keep:0);
  os = "Novell Netware " + int(version[0]) + "." + int(version[1]) / 10; 
  report = "The remote host is running " + os;
  set_kb_item(name:"Host/OS/icmp", value:os);
  security_note(port:0, data:report);
  exit(0);
  }
 }


 if ("WorkCentre Pro Multifunction System" >< os )
 {
  os = "Xerox WorkCentre Pro"; 
  report = "The remote host is running " + os;
  set_kb_item(name:"Host/OS/icmp", value:os);
  security_note(port:0, data:report);
  exit(0);
 }

 if ("AIX" >< os )
 {
  line = egrep(pattern:"AIX version", string:os);
  version = ereg_replace(pattern:".*AIX version: (.*)$", string:line, replace:"\1");
  if ( version != line )
  {
  version = split(version, sep:'.', keep:0);
  os = "AIX " + int(version[0]) + "." + int(version[1]);
  report = "The remote host is running " + os;
  set_kb_item(name:"Host/OS/icmp", value:os);
  security_note(port:0, data:report);
  exit(0);
  }
 }
}


#
# If the remote host is running Windows, we attempt to determine its exact
# name by reading the remote registry and files.
#
if ( ! get_kb_item("SMB/samba") ) 
{
if ( get_kb_item("SMB/registry_full_access") ) 
 {
 rootfile = registry_get_sz(key:"SOFTWARE\Microsoft\Windows NT\CurrentVersion", item:"SystemRoot");
 if ( rootfile ) 
 { 
  sp = registry_get_sz(key:"SOFTWARE\Microsoft\Windows NT\CurrentVersion", item:"CSDVersion");
  file = rootfile + "\system32\prodspec.ini";  
  content = smb_file_read(file:file,count:512);
  content = str_replace(find:'\r', replace:"", string:content);
  product = egrep(pattern:"^Product=", string:strstr(content, "Product="));
  lang    = egrep(pattern:"^Localization=", string:strstr(content, "Localization="));
  if (strlen(product)) {
	 product -= "Product=";
         end = strstr(product, '\n');
         product = product - end;
	 lang    -= "Localization=";
	 end = strstr(lang, '\n');
	 lang = lang - end;
	 if ( "Service Pack" >!< sp ) sp = "";
         else sp = " " + sp ;
	 version = "Microsoft " + product + sp + " (" + lang + ")";
         report = "The remote host is running " + version;
         set_kb_item(name:"Host/OS/icmp", value:version);
         security_note(port:0, data: report );
         exit(0);
       }
    } 
  }
}

#
# If NTP is open, try to read data from there. We have to
# normalize the data we get, which is why we don't simply
# spit out 'Host/OS/ntp'
#
os = get_kb_item("Host/OS/ntp");
if ( os )
{
 processor = get_kb_item("Host/processor/ntp");
 # Normalize intel CPUs 
 if ( processor && ereg(pattern:"i[3-9]86", string:processor)) processor = "i386"; 

 # Mac OS X
 if ("sparcv9-wrs-vxworks" >< os )
 { 
   version = "VxWorks";
   report = "The remote host is running " + version;
   set_kb_item(name:"Host/OS/icmp", value:version);
   security_note(port:0, data: report );
   exit(0);
 }
 if ( "Darwin" >< os && "Power Macintosh" >< processor )
 {
   os -= "Darwin";
   num = split(os, sep:".", keep:FALSE);
   version = "Mac OS X 10." + string(int(num[0]) - 4) + "." + num[1];
   report = "The remote host is running " + version;
   set_kb_item(name:"Host/OS/icmp", value:version);
   security_note(port:0, data: report );
   exit(0);
 }

 if ("UNIX/HPUX" >< os )
 {
   report = "The remote host is running HP/UX";
   set_kb_item(name:"Host/OS/icmp", value:"HP/UX");
   security_note(port:0, data: report );
   exit(0);
 }
 # 'Regular' Darwin
 if ("Darwin" >< os )
 {
   os -= "Darwin";
   version = "Darwin" + os;
   if ( processor ) version += " (" + processor + ")";

   report = "The remote host is running " + version;
   set_kb_item(name:"Host/OS/icmp", value:version);
   security_note(port:0, data: report );
   exit(0);
 }

 if ("NetBSD" >< os )
 {
   os -= "NetBSD";
   version = "NetBSD " + os;
   if ( processor ) version += " (" + processor + ")";

   report = "The remote host is running " + version;
   set_kb_item(name:"Host/OS/icmp", value:version);
   security_note(port:0, data: report );
   exit(0);
 } 

 if ("FreeBSD" >< os )
 {
   os -= "FreeBSD";
   version = "FreeBSD " + os;
   if ( processor ) version += " (" + processor + ")";

   report = "The remote host is running " + version;
   set_kb_item(name:"Host/OS/icmp", value:version);
   security_note(port:0, data: report );
   exit(0);
 }

 if ("OpenBSD" >< os )
 {
   os -= "OpenBSD";
   version = "OpenBSD" + os;
   if ( processor ) version += " (" + processor + ")";

   report = "The remote host is running " + version;
   set_kb_item(name:"Host/OS/icmp", value:version);
   security_note(port:0, data: report );
   exit(0);
 }

 if ("Linux" >< os )
 {
   if ("Linux/" >< os ) os -= "Linux/";
   else os -= "Linux";
   os = "Linux Kernel " + os;
   version = os;
   if ( processor ) version += " (" + processor + ")";
   report = "The remote host is running " + version;
   set_kb_item(name:"Host/OS/icmp", value:version);
   security_note(port:0, data: report );
 }

 if ("SunOS5." >< os )
 {
  os -= "SunOS5.";
  if ( int(os) >= 7 ) os = "Sun Solaris " + os;
  else os = "Sun Solaris 2." + os;
  version = os;
  if ( processor ) version += " (" + processor + ")";
  report = "The remote host is running " + version;
  set_kb_item(name:"Host/OS/icmp", value:version);
  security_note(port:0, data: report );
 }

}


ttl = 0; # global
ip_id_sent = "1"; # global
MAX_RETRIES = 3;

db = "
# Submitted by Kendall Risselada
6624M TigerSwitch 10/100:1:1:0:64:1:64:1:0:64:1:0:64:1:8:64:0:1:0:0:3:1:3:0:1:64:8192:MNW:0:N:N
# Submitted by KK Liu
3Com SuperStack II:1:1:0:32:1:32:1:0:32:1:0:32:1:>64:32:0:1:1:1:1:1:1:0:1:32:2048:M:N:N:N
A4/600 Label Printer:1:1:0:32:1:32:1:0:32:1:0:32:1:8:32:0:1:1:2:1:1:1:0:1:32:8192:M:N:N:N
AIX 4.0/4.2:1:1:1:255:1:255:1:0:255:1:1:255:1:8:255:1:1:1:2:1:>20:1:0:1:64:16060:M:N:N:N
AIX 4.2:1:1:1:255:1:255:1:0:255:1:1:255:1:8:255:1:1:1:2:1:>20:1:0:1:64:16340:M:N:N:N 
AIX 4.0:1:1:1:255:1:255:1:0:255:1:0:255:1:8:255:1:1:0:2:1:>20:1:1:1:64:16060:M:N:N:N
AIX 4.3:1:1:1:255:0:255:1:0:255:1:1:255:1:8:255:1:1:0:2:1:>20:1:1:1:64:16060:M:N:N:N
AIX 4.3:1:1:1:255:1:255:1:0:255:1:1:255:1:8:255:1:1:0:2:1:>20:1:1:1:64:16060:M:N:N:N 
AIX 5.1:1:1:1:255:1:255:1:0:255:1:1:255:1:8:255:1:1:0:2:1:>20:1:0:1:64:65160:MNWNNT:0:1:1
AIX 5.1:1:1:1:255:1:255:1:0:255:1:1:255:1:8:255:1:1:0:2:1:>20:1:1:1:64:65535:MNWNNTNNS:4:1:1
APC PowerNet UPS:1:1:0:255:0:255:1:0:255:1:0:255:1:8:255:0:1:1:1:1:1:1:1:1:64:4344:MNWNNT:0:1:1
APC PowerNet UPS:1:1:0:255:0:255:1:0:255:1:0:255:1:8:255:0:1:1:1:1:1:1:1:1:64:4344:MNWNNSNNT:0:1:1   
APC PowerNet UPS:0:1:0:64:1:64:1:0:64:1:1:64:1:8:64:0:1:2:1:1:1:1:0:1:64:1600:M:N:N:N 
ExtremeNetwork Switch:1:1:1:128:1:128:1:1:128:1:0:128:1:8:128:1:1:0:2:1:>20:1:0:1:32:4096:M:N:N:N 
HP JetDirect:0:1:0:64:0:64:1:0:64:1:0:64:1:8:64:0:1:1:1:1:1:1:0:1:64:2144:M:N:N:N 
HP JetDirect:1:1:1:64:0:64:1:0:64:1:0:64:1:8:64:1:1:0:0:3:1:3:0:1:64:8192:MNW:0:N:N
HP JetDirect:1:1:1:64:0:64:1:0:64:1:0:64:1:8:64:1:1:0:0:3:1:3:0:1:64:1460:MNWNNT:0:1:1 
HP Integrated Lights Out Board:1:1:0:64:0:64:1:0:64:1:0:64:1:8:64:0:1:1:1:1:1:1:0:1:64:5840:M:N:N:N
HP P1218A TopTools Remote Control:1:1:1:255:1:255:1:1:255:1:1:255:1:8:255:1:1:1:0:1:1:3:0:1:64:4096::N:N:N 
HP Integrated Lights Out Board:1:1:1:64:1:64:1:0:64:1:0:64:1:8:64:1:1:0:0:1:1:1:0:1:64:8192:MNWNNT:0:1:1
HP Integrated Lights Out Board:1:1:0:64:0:64:1:0:64:1:0:64:1:8:64:0:1:1:1:1:1:1:0:1:64:5840:MS:N:N:N

IBM OS/390:0:1:0:32:0:32:1:0:32:1:0:32:1:8:32:0:1:1:1:1:1:1:0:1:32:65535:MNWNNT:4:1:1
IBM OS/390:1:1:0:64:1:64:1:0:64:1:0:64:1:8:64:0:1:1:1:1:1:1:0:1:64:32768:MNNT:N:1:1
Lexmark Printer:0:1:0:255:0:255:1:0:255:1:0:255:1:8:255:0:1:1:2:1:1:1:0:1:255:1010:M:N:N:N
Microsoft Windows 2000 Professional:0:1:1:128:1:128:1:0:128:1:0:128:1:8:128:0:1:1:1:1:1:1:1:1:128:64512:MNWNNTNNS:0:0:0 
Microsoft Windows 95:0:1:1:128:0:128:1:0:128:1:0:128:1:8:128:0:1:1:1:1:1:1:1:1:128:8760:MNWNNTNNS:0:0:0
NCR MP-RAS SVR4 UNIX:1:1:1:64:1:64:1:0:64:1:0:64:1:8:64:1:1:1:1:1:1:1:1:1:64:24820:MNWNNT:0:1:1
PolyCom ViewStation:0:1:1:64:0:64:1:0:64:1:0:64:1:64:64:0:1:1:1:1:1:1:0:1:64:23360:M:N:N:N
PowerShow NetworKam webcam=:1:1:0:64:0:64:1:0:64:1:0:64:1:8:64:0:1:1:1:1:1:1:0:1:64:2144:M:N:N:N 
Raptor Firewall:1:1:1:64:1:64:1:1:64:1:1:64:1:8:64:1:1:1:1:1:1:1:0:1:64:61440:MNW:0:N:N 
Sun Solaris 8:1:1:1:255:1:255:1:1:255:1:0:255:1:64:255:1:1:1:1:1:1:1:1:1:64:17376:NNTNWNNSM:0:1:1
Sun Solaris 8:1:1:1:255:1:255:1:1:255:1:0:255:1:64:255:1:1:1:1:1:1:1:1:1:64:65160:NNTNWNNSM:0:1:1
Symantec Enterprise Firewall:1:1:1:255:0:255:1:0:255:1:0:255:1:8:255:0:1:1:1:1:1:1:1:1:255:10136:NNTNWNNSM:0:1:1
Tekronix Printer:1:1:0:128:0:128:1:0:128:1:0:128:1:8:128:0:1:1:1:1:1:1:0:1:128:2920:M:N:N:N 
UNIX System V Release 4.0::1:1:1:255:1:255:1:1:255:1:0:255:1:64:255:1:1:1:1:1:1:1:1:1:64:49232:NNTNWNNSM:1:1:1
Xerox Printer:1:1:1:255:1:255:1:1:255:1:1:255:1:8:255:1:1:0:0:3:1:3:0:1:32:4096:M:N:N:N
Xerox Printer:1:1:1:255:1:255:1:0:255:1:0:255:1:8:255:1:1:0:0:3:>20:3:0:1:64:16384:M:N:N:N
AltaVista Tunnel Server:1:1:1:64:0:64:1:0:64:1:0:64:1:8:64:1:1:0:1:1:1:1:1:1:64:33580:MNW:0:N:N


# Submitted by Michael Scheidell
3Com SuperStack II:1:1:0:255:0:255:1:0:255:1:0:255:1:8:255:0:1:1:1:1:1:1:0:1:255:1024:M:N:N:N

# Submitted by Richard Shinebarger
A/UX 3.11:1:1:1:255:1:255:1:1:255:1:1:255:1:8:255:1:1:0:0:1:1:1:0:1:32:4096:M:N:N:N

# Submitted by Joannathan Herv : ATLAS 550 Rev B03
Adtran ATLAS 550:0:1:0:64:0:64:1:1:64:1:0:64:1:8:64:0:1:1:2:1:1:1:0:1:64:4096:M:N:N:N

# Submitted by Daniel Wesemann
AIX 4.0:1:1:1:255:1:255:1:0:255:1:1:255:1:8:255:1:1:0:2:3:>20:1:1:1:64:64240:M:N:N:N
AIX 4.0:1:1:1:255:1:255:1:0:255:1:1:255:1:8:255:1:1:0:2:3:>20:1:1:1:64:65535:MNWNNT:2:1:1

# Submitted by Ragis Guirguis
AIX 5.1:1:1:1:255:1:255:1:0:255:1:1:255:1:8:255:1:1:0:2:1:>20:1:0:1:64:65535:MNWNNT:4:1:1

AIX 5.1:1:1:1:255:1:255:1:0:255:1:1:255:1:8:255:1:1:0:2:1:>20:1:0:1:64:51100:M:N:N:N

# Submitted by Ahmet Ozturk
AIX 5.1:1:1:1:255:1:255:1:0:255:1:1:255:1:8:255:1:1:0:2:1:>20:1:0:1:64:65535:M:N:N:N


# Submitted by Peters Devon
AIX 5.1:1:1:1:255:1:255:1:0:255:1:1:255:1:8:255:1:1:0:2:1:>20:1:1:1:64:17520:M:N:N:N

# Submitted by Owen Crow
AIX 5.2:1:1:1:255:1:255:1:0:255:1:1:255:1:8:255:1:1:0:2:1:>20:1:0:1:64:17520:M:N:N:N

# Submitted by Shawn Leard
AIX 5.2:1:1:1:255:1:255:1:0:255:1:1:255:1:8:255:1:1:0:2:1:>20:1:0:1:64:17376:MNWNNT:0:1:1

# Submitted by Piotr Lasota
AIX 5.2:1:1:1:255:1:255:1:0:255:1:1:255:1:8:255:1:1:0:2:1:>20:1:1:1:64:65535:M:N:N:N

# Submitted by Peter Eckel
AIX 4.3:1:1:1:255:1:255:1:0:255:1:1:255:1:8:255:1:1:0:2:1:>20:1:0:1:64:16060:M:N:N:N

# Submitted by Heiko Geist
AIX 4.1:1:1:1:255:1:255:1:0:255:1:1:255:1:8:255:1:1:0:2:1:>20:1:1:1:64:15400:M:N:N:N

# Submitted by omri
Alcatel Speed Touch Pro:1:1:1:255:1:255:1:1:255:1:0:255:1:8:255:1:1:1:0:1:1:1:0:1:64:4096:MNWNNT:0:1:1

# submitted by Scott Bentley
Allied Telesyn AR320 Router:0:S:1:64:1:64:S:1:64:S:0:64:S:8:255:0:1:1:1:1:1:1:0:1:64:1024:M:N:N:N

# Submitted by Lior Rotkovitch - NetEnforcer AC202
Allot NetEnforcer:1:1:0:255:1:255:1:0:255:1:0:255:1:>64:255:0:1:1:1:1:1:1:1:1:64:1360:MSTNW:0:1:1

# Submitted by Roberto Marinello - alteon 184
Alteon:1:1:0:255:0:255:1:0:255:1:0:255:1:8:255:0:1:1:1:1:1:1:0:1:255:8760:M:N:N:N

# Submitted by Nicolas S. Dade
Alteon:1:1:0:255:0:255:1:0:255:1:0:255:1:8:255:0:1:1:1:1:1:1:0:1:255:4096:M:N:N:N


# Submitted by sullo
AsyncOS:1:1:1:64:1:64:1:0:64:1:0:64:1:8:64:1:1:0:1:3:1:1:1:1:64:16384:MNWNNT:0:1:1

# Submitted by Stephen Weeber - version 3.1.58
Avaya VPNet VSU 2000::1:1:1:255:1:255:1:0:255:1:0:255:1:8:255:1:1:0:0:3:>20:3:0:1:64:4380:M:N:N:N


# Submitted by Simon Fretz
Baystack Switch:1:1:0:64:0:64:1:0:64:1:0:64:1:8:64:0:1:1:1:1:1:1:0:1:64:1024:M:N:N:N
Baystack Switch:1:1:0:32:0:32:1:0:32:1:0:32:1:8:32:0:1:1:1:1:1:1:0:1:32:1024:M:N:N:N

# Submitted by Joel (asmodianx) (firmware 1.10.008, boot 1.13, hw 01)
Belkin Wireless Router:1:1:1:64:1:64:1:0:64:1:0:64:1:X:X:X:X:X:X:X:X:X:0:1:64:8192:MNW:0:N:N

# Submitted by Dennis Feijen -  BINTEC-X4000 version V.5.1 Rev. 6 
Bintec Router:1:1:1:64:0:64:1:0:64:1:0:64:1:8:64:0:1:1:2:3:1:3:0:1:64:4096:M:N:N:N

# Submited by Matthias Geiser
BlueCoat SG400:1:1:1:255:0:255:1:0:255:1:0:255:1:8:255:1:1:0:0:3:>20:3:0:1:64:65535:MNWNNT:0:1:1

# Submitted by Benjamin Zak
BreezeAccess SU-I Local Loop Radio:1:1:0:64:0:64:1:0:64:1:0:64:1:8:64:1:1:1:1:1:1:1:1:1:64:1500::N:N:N

# Submitted by rio@rio.st
BUG inc. IP stack:0:1:0:64:0:64:1:0:64:1:0:64:1:8:64:0:1:1:1:1:1:1:0:1:64:8192:M:N:N:N
# Submitted by H D Moore
Cabletron Switch:1:1:0:32:0:32:1:1:32:1:0:32:1:8:255:1:S:0:1:1:1:1:0:0:32:4096::N:N:N

# Submitted by Ken Welker
Cayman DSL Router:1:1:0:32:0:32:1:0:32:1:0:32:1:8:255:0:1:1:1:1:1:1:0:1:32:4096::N:N:N


CISCO IOS 11.2:1:S:1:255:1:255:S:0:255:S:1:255:S:8:255:0:1:1:1:1:1:1:0:0:255:4288:M:N:N:N
# Submutted by Arnod Nipper
CISCO IOS 12.0:1:S:1:255:0:255:1:0:255:1:0:255:1:8:255:0:1:2:1:1:1:1:0:0:255:4128:M:N:N:N
# Submitted by Joannathan Herv : CISCO IOS 12.0(9)
CISCO IOS 12.0:1:S:1:255:1:255:S:0:255:S:1:255:S:8:255:0:1:1:1:1:1:1:0:0:255:4128:M:N:N:N
# Submitted by Marco Teixeira : CISCO IOS 12.0(5)
CISCO IOS 12.0:1:S:1:255:1:255:S:0:255:S:0:255:S:8:255:0:1:1:1:1:1:1:0:0:255:4128:M:N:N:N

CISCO IOS 12.1:1:S:1:255:1:255:S:0:255:S:1:255:S:8:255:0:1:1:2:1:1:1:0:0:255:4128:M:N:N:N

# Submitted by Richard Harvey
CISCO IOS 12.2:1:S:1:255:0:255:1:0:255:1:0:255:1:8:255:0:1:2:2:1:1:1:0:0:255:4128:M:N:N:N
CISCO IOS 12.3:1:S:1:255:1:255:S:0:255:S:0:255:S:8:255:0:1:1:1:1:1:1:0:0:255:4128:M:N:N:N

# Submitted by Maarten Hartsuikjker
CISCO IOS 12.2:1:S:1:255:1:255:S:0:255:S:1:255:S:8:255:0:1:1:1:1:1:1:0:0:255:1460:M:N:N:N

# Submitted by Wany Barber
CISCO IOS 12.3:1:S:1:255:0:255:1:0:255:1:0:255:1:8:255:0:1:1:1:1:1:1:0:0:255:4128:M:N:N:N
# Actually 4.2.3
CISCO Local Director 4.2:1:1:1:64:0:64:1:0:64:1:0:64:1:X:X:X:X:X:X:X:X:X:X:0:1:255:4096:M:N:N:N

# Submitted by Jamyn
CISCO Catalyst 5000:1:1:1:64:1:64:1:1:64:1:1:64:1:8:64:1:1:0:0:1:1:1:0:1:32:4096::N:N:N

# Submitted by Erik Linder
CISCO IP Telephone 7940:1:1:0:64:0:64:1:0:64:1:0:64:1:8:64:0:1:1:1:1:1:1:0:1:64:1400:M:N:N:N

# Submitted by H D Moore
CISCO VPN Concentrator:1:S:1:128:0:128:1:0:128:1:0:128:1:8:128:0:0:1:1:1:1:1:1:S:128:5840::N:N:N


Clark Connect Firewall:1:1:0:64:1:64:1:0:64:1:0:64:1:>64:64:0:1:1:2:1:1:1:1:0:64:5792:MSTNW:1:1:1


# Submitted by Guy RayMakers
Cyclades Terminal Server:1:1:0:255:0:255:1:0:255:1:0:255:1:>64:255:0:1:1:1:3:1:1:1:0:64:5792:MSTNW:0:1:1

Digital Unix 4.0:1:1:1:64:1:64:1:0:64:1:1:64:1:8:64:1:1:0:1:1:1:1:1:1:64:33580:MNW:0:N:N

# Submitted by Adam LaFrenier - PowerConnect 3024 and 3048
Dell PowerConnect Switch:1:1:1:255:1:255:1:0:255:1:0:255:1:8:255:1:1:0:0:1:>20:1:0:1:64:8192:MNWNNT:0:1:1

DryStar Printer:0:1:0:255:0:255:1:1:255:1:0:255:1:8:255:0:1:1:1:1:1:1:0:1:64:8760:M:N:N:N


# Submitted by Keith Duarte
D-Link Router:1:1:0:128:1:128:1:0:128:1:0:128:1:8:128:0:1:1:1:1:1:1:0:1:128:8192:M:N:N:N
# Submitted by Marc at spooshland.com
D-Link Router:1:1:0:64:0:64:1:0:64:1:0:64:1:8:64:0:1:1:1:1:1:1:0:1:64:5808:M:N:N:N
D-Link WLAN Access Point:1:1:0:32:0:32:1:0:32:1:0:32:1:X:X:X:X:X:X:X:X:X:0:1:32:16000:M:N:N:N
# Actually a DI-713P WAP
D-Link DI-713P WLAN Access Point:1:1:0:64:0:64:1:0:64:1:0:64:1:8:64:0:1:1:1:1:1:1:0:1:64:5840:M:N:N:N
# Actually a DI-624 WAP
D-Link DI-624 WLAN Access Point:1:1:0:128:1:128:1:0:128:1:0:128:1:8:128:0:1:1:1:1:1:1:0:1:128:8192:M:N:N:N
D-Link DI-624+ WLAN Access Point:1:1:0:128:1:128:1:0:128:1:0:128:1:8:128:0:1:1:1:1:1:1:0:1:128:8192:M:N:N:N
# Submitted by Thomas Ratz
D-Link DI-614+ WLAN Access Point:1:1:0:128:1:128:1:0:128:1:0:128:1:8:128:0:1:1:1:1:1:1:0:1:128:8192:MW:0:N:N
# Submitted by Erik Brostrm
D-Link DI-604 Router:1:1:0:64:0:64:1:0:64:1:0:64:1:8:64:0:1:1:1:1:1:1:0:1:64:5840:MS:N:N:N

# Submitted by Charles G Griebel. Version 4.2.20.100
EMC Celerra File Server:1:1:0:255:0:255:1:0:255:1:0:255:1:8:255:0:1:1:2:3:1:3:0:1:64:65535:MNWNNT:3:1:1

# Submitted by 'nts'
ELSA LANCOM Wireless Router:1:1:0:64:0:64:1:0:64:1:0:64:1:8:64:0:1:1:1:1:1:1:0:1:64:1400::N:N:N

# Submitted by H D Moore
Enterasys Vertical Horizon Switch:1:1:1:255:1:255:1:1:255:1:1:255:1:8:255:1:1:1:0:1:1:1:0:1:64:4096::N:N:N
Enterasys XSR-1805:1:S:1:255:0:255:1:1:255:S:0:255:S:8:255:0:0:1:1:1:1:1:0:1:255:8192:MNWNNT:0:1:1
# Submitted by Daniel Wesemann  - see www.brocade.com
Fabric OS:1:1:1:255:1:255:1:1:255:1:1:255:1:8:255:1:1:0:0:3:1:3:0:1:32:4096:M:N:N:N


F5 Networks Appliance:1:1:1:255:1:255:1:0:255:1:0:255:1:8:255:1:1:1:2:3:1:1:1:1:64:17520:MNWNNT:0:1:1
Foundry Networks Load Balancer:1:1:0:64:0:64:1:0:64:1:0:64:1:64:64:0:1:1:1:1:1:1:0:1:64:16384:M:N:N:N
Foundry Networks Load Balancer:1:1:0:64:0:64:1:0:64:1:0:64:1:8:64:0:1:2:1:1:1:1:0:1:64:16384:M:N:N:N

# Submitted by Marco IANNOZI and Owen Crow
HP/UX B.11.11:1:1:1:255:0:255:1:0:255:1:0:255:1:64:255:1:1:1:1:1:1:1:1:1:64:32768:MNNSWNNNT:0:1:1

HP/UX B.11.0:1:1:1:255:0:255:1:1:255:1:0:255:1:64:255:1:1:1:1:1:1:1:1:1:64:32768:MNNSWNNNT:0:1:1

# Submitted by Renaud Fortier
HP/UX 10.20:1:1:1:255:1:255:1:0:255:1:1:255:1:8:255:1:1:1:0:1:1:1:1:1:64:32768:M:N:N:N


# Submitted by Pauli Burodulin - HP LaserJet 4100
HP JetDirect:1:1:1:64:1:64:1:0:64:1:0:64:1:8:64:1:1:0:0:3:1:3:0:1:64:5840:MNW:0:N:N
HP JetDirect:1:1:1:64:1:64:1:0:64:1:0:64:1:8:64:1:1:0:0:3:1:3:0:1:64:8192:MNW:0:N:N
HP JetDirect:0:1:0:64:0:64:1:0:64:1:0:64:1:8:64:0:1:1:0:1:1:1:0:1:64:2144:M:N:N:N

# Submitted by Lee Reynolds - HP LaserJet 2300
HP JetDirect:1:1:1:64:1:64:1:0:64:1:0:64:1:8:64:1:1:0:0:3:1:3:0:1:64:5840:MNWNNT:0:1:1
# Submitted by H D Moore
HP JetDirect:0:1:0:64:0:64:1:0:64:1:0:64:1:8:64:0:1:1:1:1:1:1:0:1:64:5840:M:N:N:N
HP JetDirect:1:1:1:64:1:64:1:0:64:1:0:64:1:8:64:1:1:0:0:3:1:3:0:1:64:1460:MNW:0:N:N
HP JetDirect:1:1:1:64:1:64:1:0:64:1:0:64:1:8:64:1:1:0:0:3:1:3:0:1:64:1460:MNWNNT:0:1:1

# Subitted by Daniel Wesemann
HP JetDirect:0:1:0:64:0:64:1:0:64:1:0:64:1:8:64:0:1:1:1:3:1:1:0:1:64:5840:M:N:N:N

# Submitted by Aaron Smith
HP ProCurve Switch:1:1:1:64:1:64:1:1:64:1:1:64:1:8:64:1:1:0:0:3:1:3:0:1:64:4096:M:N:N:N
# Submitted by Kendall Risselada
HP ProCurve Switch:1:1:0:64:1:64:1:0:64:1:0:64:1:8:64:0:1:0:0:1:1:3:0:1:64:8192:MNW:0:N:N

HP IP Console Switch:1:0:1:255:1:255:0:0:255:0:0:255:0:>64:255:1:0:1:1:1:1:1:1:0:64:5792:MSTNW:0:1:1


FreeBSD 5.3:1:1:1:64:1:64:1:0:64:1:0:64:1:8:64:1:1:0:2:1:1:1:1:1:64:65535:MNWNNTNNS:1:1:1
FreeBSD 5.2:1:1:0:64:0:64:1:0:64:1:0:64:1:8:64:0:1:1:2:3:1:3:0:1:64:65535:MNWNNT:1:1:1
FreeBSD 5.2:1:1:1:64:0:64:1:0:64:1:0:64:1:8:64:1:1:0:1:1:1:1:1:1:64:65535:MNWNNT:1:1:1
FreeBSD 5.1:1:1:1:64:1:64:1:0:64:1:0:64:1:8:64:1:1:0:1:1:1:1:1:1:64:65535:MNWNNT:1:1:1
FreeBSD 4.9:1:1:1:64:1:64:1:0:64:1:0:64:1:8:64:1:1:0:1:1:1:1:1:1:64:65535:MNWNNT:0:1:1
FreeBSD 4.9:1:1:1:64:1:64:1:0:64:1:0:64:1:8:64:1:1:0:1:1:1:1:1:1:64:57344:MNWNNT:0:1:1
FreeBSD 4.9:1:1:1:64:1:64:1:0:64:1:0:64:1:8:64:1:1:0:2:1:1:1:1:1:64:57344:MNWNNT:0:1:1
FreeBSD 4.8:1:1:1:64:1:64:1:0:64:1:0:64:1:8:64:1:1:0:1:1:1:1:1:1:64:57344:MNWNNT:0:1:1
FreeBSD 4.7:1:1:1:64:1:64:1:0:64:1:0:64:1:8:64:1:1:0:1:1:1:1:1:1:64:57344:MNWNNT:0:1:1
# Submitted by Shane Mullins
FreeBSD 4.6:1:1:1:64:1:64:1:0:64:1:0:64:1:8:64:1:1:0:1:1:1:1:0:1:64:57344:MNWNNT:0:1:1
FreeBSD 4.5:1:1:1:64:1:64:1:0:64:1:0:64:1:8:64:1:1:0:1:1:1:1:0:1:64:65535:MNWNNT:1:1:1
# Submitted by Boka Marek
FreeBSD 4.4:1:1:1:64:1:64:1:0:64:1:0:64:1:8:64:1:1:0:1:1:1:1:1:1:64:17376:MNWNNT:0:1:1
FreeBSD 4.2:1:1:1:255:1:255:1:0:255:1:0:255:1:8:255:1:1:0:1:1:1:1:1:1:64:17520:M:N:N:N
FreeBSD 4.1:1:1:1:255:1:255:1:0:255:1:0:255:1:8:255:1:1:0:2:3:1:3:1:1:64:17520:M:N:N:N
FreeBSD 4.0:1:1:1:255:1:255:1:0:255:1:0:255:1:8:255:1:1:0:2:3:1:3:1:1:64:17520:M:N:N:N
FreeBSD 3.5:1:1:1:255:1:255:1:0:255:1:0:255:1:8:255:1:1:0:2:3:1:3:1:1:64:17520:M:N:N:N
FreeBSD 3.4:1:1:1:255:1:255:1:0:255:1:0:255:1:8:255:1:1:0:2:3:1:3:1:1:64:17520:M:N:N:N
FreeBSD 3.3:1:1:1:255:1:255:1:0:255:1:0:255:1:8:255:1:1:0:2:3:1:3:1:1:64:17520:M:N:N:N

# Submitted by Ian Pattison
GNET Wireless Access Point:1:1:0:255:0:255:1:0:255:1:0:255:1:8:255:0:1:1:1:1:1:1:0:1:255:5840:MS:N:N:N

# Submitted by Ral Aldaz
IBM OS/400:1:1:0:64:1:64:1:0:64:1:0:64:1:8:64:0:1:1:1:1:1:1:1:1:64:8192:MNWNNT:0:1:1
IBM Gigabit Switch Module:1:S:1:32:0:32:1:0:32:1:0:32:1:8:32:0:0:1:1:1:1:1:0:1:32:8192:MNWNNT:0:1:1

# Actually is IRIX 6.5.18f
IRIX 6.5:1:1:1:255:1:255:1:0:255:1:0:255:1:8:255:1:1:1:1:1:1:1:1:1:64:60816:MNWNNTNNS:0:1:1
# Submitted by Alexander Brinkman - IRIX 6.5.20
IRIX 6.5:1:1:1:255:1:255:1:1:255:1:0:255:1:8:255:1:1:1:1:1:1:1:1:1:64:60816:MNWNNTNNS:0:1:1

# Submitted by Daniel Wesemann
JVC VN-C1U Webcam:1:1:0:64:1:64:1:1:64:1:0:64:1:8:64:0:1:1:1:3:1:1:0:1:64:4728:M:N:N:N

# Submited by Michael Tsentsarevsky
Juniper M7i:1:1:1:255:1:255:1:0:255:1:0:255:1:8:255:1:1:1:1:1:1:1:1:1:64:17376:MNWNNT:0:1:1
# Submitted by Pauli Borodolin
Konica Minolta Digital Copier/Printer:1:1:1:255:1:255:1:0:255:1:0:255:1:8:255:1:1:0:0:1:1:1:0:1:255:1:MNWNNT:0:1:1

# Submitted by Daniel Wesemann
Lantronix Printer:1:1:1:64:0:64:1:0:64:1:0:64:1:8:64:1:1:1:1:3:1:1:1:1:64:255:M:N:N:N

Lexmark Printer:1:1:1:255:1:255:1:0:255:1:0:255:1:8:255:1:1:1:1:1:1:1:1:1:255:2896:MNWNNT:0:1:1
Lexmark Printer:1:0:1:255:1:255:0:0:255:0:0:255:0:>64:255:1:0:1:1:1:1:1:1:0:255:1448:MSTNW:0:1:1


# Submitted by Aldwin Wijnveld
Lexmark Printer:0:1:0:255:0:255:1:0:255:1:0:255:1:8:255:0:1:1:2:1:1:1:0:1:255:15346:M:N:N:

# Submitted by Ron Searle (BEFSR114 router)
Linksys Router:1:S:0:64:0:64:1:0:64:1:0:64:1:8:64:0:S:1:1:1:1:1:0:0:64:5840:M:N:N:N
Linksys Router:1:1:0:255:0:255:1:0:255:1:0:255:1:8:255:0:1:1:2:1:1:1:0:1:255:5840:M:N:N:N
# Submitted by JKalf
Linksys Router::1:S:0:255:0:255:1:0:255:1:0:255:1:8:255:0:S:2:2:1:1:1:1:1:128:64240:MNWNNTNNS:0:0:0
# Submitted by alzeke
Linksys Router:1:S:0:255:0:255:1:0:255:1:0:255:1:8:255:0:S:1:1:1:1:1:0:0:255:5840:M:N:N:N
# Submitted by Christopher Walsh
Linksys Access Hub WAP11:1:1:0:64:0:64:1:0:64:1:0:64:1:8:64:0:1:1:1:1:1:1:0:1:64:4608:M:N:N:N

# Linux 2.6.9-gentoo-r4 - Michel Arboi
Linux Kernel 2.6:1:1:0:64:1:64:1:0:64:1:0:64:1:>64:64:0:1:1:2:1:1:1:1:0:64:5792:MSTNW:2:1:1

Linux Kernel 2.6:1:1:0:64:1:64:1:0:64:1:0:64:1:>64:64:0:1:1:2:1:1:1:1:0:64:5792:MSTNW:0:1:1

Linux Kernel 2.6:1:1:0:64:1:64:1:0:64:1:0:64:1:>64:64:0:1:1:1:1:1:1:1:0:64:5792:MSTNW:2:1:1

# Debian Sarge 2.6.7
Linux Kernel 2.6:1:1:0:64:1:64:1:0:64:1:0:64:1:>64:64:0:1:1:1:1:1:1:1:0:64:5760:MSTNW:0:1:1

# Submitted by Steve Sanders
Linux Kernel 2.6:1:1:0:64:1:64:1:0:64:1:0:64:1:>64:255:0:1:1:2:1:1:1:1:0:64:5792:MSTNW:2:1:

# Submitted by Mikael Andersson
Linux Kernel 2.6:1:1:0:64:1:64:1:0:64:1:0:64:1:>64:64:0:1:1:1:1:1:1:1:0:64:5792:MSTNW:7:1:1

# Submitted by Justin Wienckow
Linux Kernel 2.6:1:1:0:64:1:64:1:0:64:1:0:64:1:>64:255:0:1:1:1:1:1:1:1:0:64:5840:MNNSNW:0:N:N

# Submitted by Boris Bielous - Linux Kernel 2.6.6
Linux Kernel 2.6:1:1:0:64:0:64:1:0:64:1:0:64:1:>64:255:0:1:1:1:1:1:1:1:0:64:5792:MSTNW:0:1:1

# Submitted by Luigi Rosa - Linux Kernel 2.6
Linux Kernel 2.6:1:S:1:255:1:255:S:0:255:S:0:255:S:8:255:0:1:1:1:1:1:1:1:0:64:5792:MSTNW:0:1:1


Linux Kernel 2.4:1:1:0:64:1:64:1:0:64:1:0:64:1:8:64:0:1:1:1:1:1:1:1:1:64:5792:MTWSN:0:1:1
Linux Kernel 2.4:1:1:0:64:1:64:1:0:64:1:0:64:1:>64:255:0:1:1:2:1:1:1:1:0:64:5792:MSTNW:0:1:1
Linux Kernel 2.4:1:1:0:64:1:64:1:0:64:1:0:64:1:>64:64:0:1:1:2:1:1:1:1:0:64:5792:MSTNW:0:1:1

Linux Kernel 2.4:1:1:0:64:0:64:1:0:64:1:0:64:1:>64:64:0:1:2:1:3:1:1:1:0:64:5792:MSTNW:0:1:1

Linux Kernel 2.4:1:1:0:64:0:64:1:0:64:1:0:64:1:>64:64:0:1:2:2:1:1:3:0:0:64:5792:MSTNW:0:1:1

# Linux 2.4.26 + grsecurity - submitted by CWL Hoogenboezem
Linux Kernel 2.4:1:1:0:64:1:64:1:0:64:1:0:64:1:>64:64:0:1:2:2:1:1:1:1:1:64:5792:MSTNW:0:1:1
# Linux Gentoo 2.4.26-r10 + GrSec - Michel Arboi
Linux Kernel 2.4:1:1:0:64:1:64:1:0:64:1:0:64:1:>64:64:0:1:1:2:1:1:1:1:1:64:5792:MSTNW:0:1:1

# Linux 2.4.24 - submitted by Rodik
IPCop (Linux Kernel 2.4 firewall):1:1:0:64:1:64:1:0:64:1:0:64:1:>64:64:0:1:1:1:1:1:1:1:0:64:5840:M:N:N:N
# Linux 2.4.{19,21} - submitted by Vincent Renardias
Linux Kernel 2.4:1:1:0:64:0:64:1:0:64:1:0:64:1:>64:64:0:1:1:1:1:1:1:1:0:64:5792:MSTNW:0:1:1
# Linux Kernel 2.4.22
Linux Kernel 2.4:1:1:0:64:1:64:1:0:64:1:0:64:1:>64:64:0:1:1:1:1:1:1:0:1:64:5592:MSTNW:0:1:1


# Linux 2.4.20-28.7 (Dragon) - submitted by Mike Leahy
Linux Kernel 2.4:1:1:0:64:1:64:1:0:64:1:0:64:1:>64:64:0:1:1:1:1:1:1:1:0:64:5512:MSTNW:0:1:1

# Linux 2.4.21-15 (RHEL AS3) - submitted by Jason Dravet
Linux Kernel 2.4:1:1:0:64:1:64:1:0:64:1:0:64:1:>64:255:0:1:1:1:1:1:1:1:0:64:5792:MSTNW:0:1:1
# Linux 2.4.20 - submitted by Clyde Hoadley
Linux Kernel 2.4:1:1:0:64:1:64:1:0:64:1:0:64:1:>64:64:0:1:1:1:1:1:1:1:1:64:5792:MSTNW:0:1:1

# Submitted by Paul Kuhanst
Linux Kernel 2.4:1:1:0:64:1:64:1:0:64:1:0:64:1:>64:64:0:1:1:1:3:1:1:1:0:64:5792:MSTNW:0:1:1

# 2.4.17 to 2.4.xx
Linux Kernel 2.4:1:1:0:64:1:64:1:0:64:1:0:64:1:>64:64:0:1:1:1:1:1:1:1:0:64:5792:MSTNW:0:1:1

# Linux 2.4.4 by Maximilian Eul
Linux Kernel 2.4:1:0:1:255:1:255:0:0:255:0:0:255:0:>64:255:1:1:1:1:1:1:1:1:0:64:5792:MSTNW:0:1:1
# This actually is 2.4.0 to 2.4.17
Linux Kernel 2.4:1:1:0:255:1:255:1:0:255:1:0:255:1:>64:255:0:1:1:1:1:1:1:1:0:64:5792:MSTNW:0:1:1

# Linux 2.4.18 on SuSE - by Billy Holmes
Linux Kernel 2.4:1:1:0:255:0:255:1:0:255:1:0:255:1:>64:255:0:1:1:1:1:1:1:1:0:64:5792:MSTNW:0:1:1

Linux Kernel 2.4:1:1:0:255:1:255:1:0:255:1:0:255:1:64:255:0:1:1:1:1:1:1:1:1:128:5792:MSTNW:0:1:1
Linux Kernel 2.4:1:1:0:255:1:255:1:0:255:1:0:255:1:64:255:0:1:1:1:1:1:1:1:1:64:5792:MSTNW:0:1:1

# Submitted by Ryan Tryssernaar
Linux Kernel 2.2:1:1:0:255:1:255:1:0:255:1:0:255:1:>64:255:0:1:1:1:1:1:1:1:1:64:32120:MSTNW:0:1:1

# Submitted by H D Moore
Linux Kernel 2.2:1:1:0:255:1:255:1:0:255:1:0:255:1:64:255:0:1:1:1:1:1:1:1:1:64:16060:MSTNW:0:1:1

# Submitted by Greg Roelofs
Linux Kernel 2.0:1:1:0:64:1:64:1:0:64:1:0:64:1:>64:64:0:1:1:1:1:1:1:0:1:64:16352:M:N:N:N


Mac OS X 10.3:1:1:1:64:0:64:1:0:64:1:0:64:1:8:64:1:1:0:1:1:1:1:1:1:64:65535:MNWNNT:0:1:1
# Submitted by Evan Wunderle - Mac OS 10.3.2
Mac OS X 10.3:1:1:1:64:0:64:1:0:64:1:0:64:1:8:64:1:1:0:1:1:1:1:1:1:64:33304:MNWNNT:0:1:1
# 10.3.2 by 'rewriteit'
Mac OS X 10.3:1:1:1:64:0:64:1:0:64:1:0:64:1:8:64:1:1:0:1:1:1:1:1:1:64:65535:MNWNNT:1:1:1
# Submitted by Geoff King
Mac OS X 10.2:1:1:1:64:1:64:1:0:64:1:0:64:1:8:64:1:1:0:1:1:1:1:1:1:64:33304:MNWNNT:0:1:1



# Submitted by Ricardo Stella
Mac OS 9:1:1:1:255:0:255:1:1:255:1:0:255:1:64:255:1:1:2:1:3:1:1:1:1:255:1380:MWNNNT:0:1:1
# Mac OS 8.6
Mac OS 8:1:1:1:255:0:255:1:1:255:1:0:255:1:64:255:1:1:2:1:3:1:1:1:1:255:1380:MW:0:N:N

# Submitted by H D Moore
Microsoft Longhorn:0:1:0:128:0:128:1:0:128:1:0:128:1:64:128:0:1:1:1:1:1:1:1:1:128:16384:MWNST:0:1:1

# Submitted by Chris Gamboni
Microsoft Windows 2003 Server:0:1:1:128:1:128:1:0:128:1:0:128:1:>64:128:0:1:1:1:1:1:1:1:1:128:17520:MNWNNTNNS:0:0:0
Microsoft Windows 2003 Server:0:1:1:128:1:128:1:0:128:1:0:128:1:>64:128:0:1:1:1:1:1:1:1:1:128:65535:MNWNNTNNS:0:0:0
# Submitted by Andrew Cox
Microsoft Windows 2003 Server:0:1:0:128:0:128:1:0:128:1:0:128:1:>64:128:0:1:2:1:1:1:3:0:1:128:17520:MNWNNTNNS:0:0:0
# Submitted by Burt Soltero
Microsoft Windows 2003 Server:0:1:1:128:1:128:1:0:128:1:0:128:1:>64:128:0:1:1:1:1:1:1:0:1:128:16384:MNWNNTNNS:0:0:0
# Submitted by Kulbinder S Kalirai
Microsoft Windows 2003 Server:1:1:0:64:1:64:1:0:64:1:0:64:1:>64:64:0:1:1:1:1:1:1:1:1:128:17520:MNWNNTNNS:0:0:0


# Submitted by Mattias Webjorn Eriksson
Microsoft Windows XP Professional:0:1:1:128:1:128:1:0:128:1:0:128:1:8:128:0:1:1:1:1:1:1:0:1:128:17520:MNWNNTNNS:0:0:0
# Submitted by Giulio Marchionni
Microsoft Windows XP Professional:0:1:1:128:1:128:1:0:128:1:0:128:1:8:128:0:1:1:1:1:1:1:0:1:128:65340:MNWNNT:0:0:0
# Submitted by Kai Hofmann - XP Pro SP1
Microsoft Windows XP Professional:0:1:1:128:1:128:1:0:128:1:0:128:1:8:128:0:1:1:1:1:1:1:1:1:128:64440:MNWNNTNNS:0:0:0
Microsoft Windows XP Professional:0:1:1:128:1:128:1:0:128:1:0:128:1:8:128:0:1:1:1:1:1:1:1:1:128:64240:MNWNNTNNS:0:0:0
Microsoft Windows XP Professional:0:1:1:128:1:128:1:0:128:1:0:128:1:8:128:0:1:1:1:1:1:1:1:1:128:17520:MNWNNTNNS:0:0:0
# Submitted by Jim Cassata - XP Pro + Cisco vpn 3.5.2
Microsoft Windows XP Professional:0:1:1:128:1:128:1:0:128:1:0:128:1:8:128:0:1:1:1:1:1:1:1:1:128:65268:MNWNNTNNS:0:0:0
# Submitted by Yoni
Microsoft Windows XP Professional:0:1:1:128:1:128:1:0:128:1:0:128:1:8:128:0:1:1:1:1:1:1:1:1:128:17680:MNWNNTNNS:0:0:0
# Submitted by Zube
Microsoft Windows XP Professional:0:1:1:128:1:128:1:0:128:1:0:128:1:8:128:0:1:1:1:1:1:1:0:1:128:16384:MNNS:N:N:N
# Submitted by Olivier Marechal - SP1
Microsoft Windows XP Professional:0:1:1:64:1:64:1:0:64:1:0:64:1:8:64:0:1:1:1:1:1:1:1:1:64:64240:MNWNNS:2:N:N
# Submitted by Petar Krasmirov
Microsoft Windows XP Professional:0:1:1:128:0:128:1:0:128:1:0:128:1:8:128:0:1:1:1:1:1:1:1:1:128:65280:MNWNNTNNS:0:0:0
# Submitted by Ruslan Savshyn
Microsoft Windows XP Professional:0:1:1:128:0:128:1:0:128:1:0:128:1:8:128:0:1:1:1:1:1:1:1:1:128:64240:MNWNNTNN:0:0:0
# Submitted by 'Securite Antivirus' (ac-besancon)
Microsoft Windows XP Professional:0:1:1:128:1:128:1:0:128:1:0:128:1:8:128:0:1:1:1:1:1:1:1:1:128:65520:MNWNNTNNS:0:0:0

# Submitted by Jutta Zalud
Microsoft Windows XP Home Edition:0:1:1:128:1:128:1:0:128:1:0:128:1:8:128:0:1:1:1:1:1:1:0:1:128:17680:MNWNNTNNS:0:0:0

Microsoft Windows XP Home Edition:0:1:1:128:1:128:1:0:128:1:0:128:1:8:128:0:1:2:1:1:1:1:1:1:128:64240:MNWNNTNNS:0:0:0

# Submitted by Todd
Microsoft Windows 2000 Server Service Pack 4:0:1:1:128:1:128:1:0:128:1:0:128:1:8:128:0:1:2:1:1:1:1:1:1:128:65535:MNWNNTNNS:0:0:0
# Submitted by Erik Ball
Microsoft Windows 2000 Server Service Pack 4:0:1:1:128:1:128:1:0:128:1:0:128:1:8:128:0:1:1:1:1:1:1:0:1:128:65535:MNWNNTNNS:0:0:0
# Submitted by Christopher Walsh
Microsoft Windows 2000 Server Service Pack 4:0:1:1:128:0:128:1:0:128:1:0:128:1:8:128:0:1:1:1:1:1:1:1:1:128:17520:MNWNNTNNS:0:0:0
# Submitted by Paul MacLennan
Microsoft Windows 2000 Server Service Pack 4:0:1:1:128:0:128:1:0:128:1:0:128:1:8:128:0:1:1:1:1:1:1:1:1:128:65535:MNWNNTNNS:0:0:0
# Submitted by Lance Lloyd
Microsoft Windows 2000 Server Service Pack 4:0:1:1:128:0:128:1:0:128:1:0:128:1:8:128:0:1:2:1:1:1:1:1:1:128:17640:MNWNNTNNS:0:0:0

# Submitted by Skyler Bingham
Microsoft Windows 2000 Server Service Pack 2:0:1:1:128:1:128:1:0:128:1:0:128:1:8:128:0:1:1:1:1:1:1:1:1:128:16872:MNWNNTNNS:0:0:0

Microsoft Windows 2000 Server:0:1:1:128:1:128:1:0:128:1:0:128:1:8:128:0:1:1:1:1:1:1:1:1:128:65535:MNWNNTNNS:0:0:0

Microsoft Windows 2000 Professional Service Pack 4:0:1:1:128:1:128:1:0:128:1:0:128:1:8:128:0:1:1:2:1:1:1:1:1:128:17520:MNWNNTNNS:0:0:0

# Submitted by Jakob Staerk
Microsoft Windows 2000 Professional:0:1:1:128:1:128:1:0:128:1:0:128:1:8:128:0:1:1:1:1:1:1:1:1:128:64512:MNWINNTNNS:0:0:0
# Submitted by Florin Mariutea
Microsoft Windows 2000 Professional Service Pack 4:0:1:1:128:1:128:1:0:128:1:0:128:1:8:128:0:1:1:1:1:1:1:1:1:128:8760:MNWNNTNNS:0:0:
# Submitted by fr3ak
Microsoft Windows 2000 Professional Service Pack 4:0:1:1:128:1:128:1:0:128:1:0:128:1:8:128:0:1:1:1:1:1:1:1:1:128:32767:MNWNNS:0:N:N
# Submitted by Kurt Mosiejczuk
Microsoft Windows 2000 Professional Service Pack 4:0:1:1:128:1:128:1:0:128:1:0:128:1:8:128:0:1:1:1:3:1:1:0:1:128:17520:MNWNNTNNS:0:0:0

# Submitted by Nick Nero
Microsoft Windows NT 4.0 Server:0:1:1:128:0:128:1:0:128:1:0:128:1:8:128:0:1:1:1:3:1:1:1:1:128:8760:M:N:N:N
# Submitted by Ralph Utz
Microsoft Windows NT 4.0 Server:0:1:1:128:0:128:1:0:128:1:0:128:1:8:128:0:1:1:1:1:1:1:1:1:128:8280:M:N:N:N
Microsoft Windows NT 4.0 Workstation:0:1:1:128:0:128:1:0:128:1:0:128:1:8:128:0:1:1:1:1:1:1:1:1:128:8280:M:N:N:N

Microsoft Windows NT 4.0 Server:0:1:1:128:0:128:1:0:128:1:0:128:1:8:128:0:1:1:1:1:1:1:1:1:128:8760:M:N:N:N
Microsoft Windows NT 4.0 Workstation:0:1:1:128:0:128:1:0:128:1:0:128:1:8:128:0:1:1:1:1:1:1:1:1:128:8760:M:N:N:N
Microsoft Windows NT 4.0 Workstation (pre-SP3):0:1:1:128:0:128:1:1:128:1:0:128:1:8:128:0:1:1:1:1:1:1:1:1:128:8760:M:N:N:N
Microsoft Windows NT 4.0 Server (pre-SP3):0:1:1:128:0:128:1:1:128:1:0:128:1:8:128:0:1:1:1:1:1:1:1:1:128:8760:M:N:N:N

# Submitted by Roman Rodak
Microsoft Windows ME:0:1:1:128:1:128:1:1:128:1:0:128:1:8:128:0:1:2:1:1:1:1:1:1:128:8576:MNNS:N:N:N


# Submitted by Sergy Osipov
Microsoft Windows ME:0:1:1:128:1:128:1:0:128:1:0:128:1:8:128:0:1:1:1:1:1:1:1:1:128:4736:MNWNNTNNS:0:0:0

# Submitted by Martin Kown
Microsoft Windows ME:0:1:1:64:1:64:1:0:64:1:0:64:1:8:64:0:1:1:1:3:1:1:1:1:64:32767:MNWNNTNNS:0:0:0

# Submitted by George Theall
Microsoft Windows 95:0:1:1:128:0:128:1:1:128:1:0:128:1:8:128:0:1:1:1:1:1:1:1:1:128:8760:MNWNNTNNS:0:0:0

# Submitted by Patrick Davignon - 4.00.950B Build 1111
Microsoft Windows 95:0:1:1:32:0:32:1:1:32:1:0:32:1:8:32:0:1:1:1:1:1:1:1:1:32:8760:M:N:N:N


# Submitted by Slim Amamou
Microsoft Windows 98:0:1:1:64:1:64:1:1:64:1:0:64:1:8:64:0:1:1:1:1:1:1:0:1:64:8576:MNNS:N:N:N
Microsoft Windows 98:0:1:1:128:1:128:1:1:128:1:0:128:1:8:128:0:1:1:1:1:1:1:1:1:128:8760:MNNS:N:N:N

# Submitted by Martin Leung
Microsoft Windows 98:0:1:1:128:1:128:1:1:128:1:0:128:1:8:128:0:1:1:1:3:1:1:1:1:128:8760:MNNS:N:N:N

# Submitted by W. Anderson
Microsoft Windows 98:0:1:1:64:1:64:1:1:64:1:0:64:1:8:64:0:1:1:1:1:1:1:1:1:64:64240:MNNS:N:N:N

# Submitted by Ego Kastelijin
Microsoft Windows 98:0:1:1:64:1:64:1:1:64:1:0:64:1:8:64:0:1:1:1:1:1:1:1:1:64:32767:MNNS:N:N:N

# Submitted by H D Moore
Motorola Vanguard:0:1:0:64:0:64:1:1:64:1:0:64:1:8:64:0:1:1:1:1:1:1:0:1:64:2048:M:N:N:N

Motorola Vanguard:0:1:0:64:0:64:1:1:64:1:0:64:1:8:64:0:1:1:2:1:1:1:0:1:64:2048:M:N:N:N


# Submitted by Ian Anderson (version is 4.0.1.14)
Netilla Service Platform 4.0:1:1:0:64:1:64:1:0:64:1:0:64:1:>64:64:0:1:1:1:1:1:1:1:0:64:5840:MNNSNW:0:N:N

# Submitted by patrick O'connor
Netopia Router:1:1:0:255:0:255:1:0:255:1:0:255:1:8:255:0:1:1:1:1:1:1:0:1:255:2048:M:N:N:N

NetGear ProSafe VPN Firewall (FVS318):1:S:1:64:0:64:1:0:64:1:0:64:1:X:X:X:X:X:X:X:X:X:0:1:32:4095:M:N:N:N
NetGear Wireless Router (MR814):1:1:0:255:0:255:1:0:255:1:1:255:1:X:X:X:X:X:X:X:X:X:0:1:255:2048:M:N:N:N

NeXT:1:1:1:255:1:255:1:1:255:1:1:255:1:8:255:1:1:0:0:3:1:3:0:1:64:4096:MS:N:N:N


# Submitted by Audun Larsen (Netopia 3351 v8.0.10)
Netopia Router:1:1:0:255:0:255:1:0:255:1:0:255:1:8:255:0:1:1:1:1:1:1:1:1:64:57344:MNWNNT:0:1:1

# Submitted by Alonso Torres (Netopia R9100 v4.11.3)
Netopia Router:1:1:0:255:0:255:1:0:255:1:0:255:1:8:255:0:1:1:1:1:1:1:0:1:255:8800:M:N:N:N

# Submitted by H D Moore
Nortel Business Policy Switch:1:1:1:64:1:64:1:0:64:1:0:64:1:8:64:1:1:0:0:1:1:1:0:1:64:8192:MNW:0:N:N

# Submitted by Mason Brown
Nortel Contivity:1:1:1:64:0:64:1:0:64:1:0:64:1:8:64:1:1:0:2:3:1:3:0:1:64:8760:MNWNNT:0:1:1

# Submitted by jiang zuowen
Nortel 6480 Router:1:1:0:64:1:64:1:0:64:1:0:64:1:8:255:0:1:1:1:1:1:1:0:1:32:4096::N:N:N

# Submitted by Mark Basset
Nokia IPSO Firewall:1:1:1:255:0:255:1:0:255:1:0:255:1:X:X:X:X:X:X:X:X:X:0:1:64:16384:MNWNNT:0:1:1
# Submitted by Todd H
Nokia IPSO 3.5:1:1:1:255:1:255:1:0:255:1:0:255:1:>64:255:1:1:0:1:1:1:1:0:1:64:16384:MNWNNT:0:1:1
Nokia IPSO 3.7:1:1:1:255:1:255:1:0:255:1:0:255:1:>64:255:1:1:0:1:1:1:1:0:1:64:16384:MNWNNT:0:1:1

# Submitted by Nicolas Nerson - netware 5.1 SP4
Novell Netware 5.1:1:1:0:128:0:128:1:0:128:1:0:128:1:8:128:0:1:1:1:1:1:1:1:1:128:6144:MWNSNN:0:N:N
# Submitted by Dave - Novell 5.1 Server version 5.00h, NDS version 8.38
Novell Netware 5.1:1:1:0:128:0:128:1:1:255:1:0:255:1:8:128:0:1:1:1:1:1:1:1:1:128:8191:M:N:N:N
# SP6
Novell Netware 5.1:1:1:0:128:0:128:1:1:255:1:0:255:1:8:128:0:1:1:1:1:1:1:1:1:128:6144:MWNSNN:0:N:N
# Submitted by Michael Scheidell - Novell NetWare 5.60.03 March 27, 2003
Novell Netware 5.6:1:1:0:128:0:128:1:0:128:1:0:128:1:8:128:0:1:1:1:1:1:1:1:1:128:6144:MWNSNN:0:N:N
Novell Netware 5.6:1:1:0:128:0:128:1:0:128:1:0:128:1:8:128:0:1:1:1:1:1:1:1:1:128:6144:MWNSNN:1:N:N
Novell Netware 6.0:1:1:0:128:0:128:1:0:128:1:0:128:1:8:128:0:1:1:1:1:1:1:1:1:128:6144:MWNSNN:0:N:N


# Submitted by Bill Petersen
OmniSwitch:1:1:1:32:1:32:1:1:32:1:1:32:1:8:32:1:1:0:0:1:1:1:0:1:32:4096::N:N:N

OpenBSD 3.6:1:1:1:255:1:255:1:0:255:1:0:255:1:8:255:0:1:1:1:1:1:1:0:1:64:65335:MNNSNWNNT:0:1:1

# Submitted by Jay Reffner
OpenBSD 3.4:1:1:1:255:1:255:1:0:255:1:0:255:1:8:255:0:1:1:1:1:1:1:1:1:64:17376:MNNSNWNNT:0:1:1

# Submitted by Rich
OpenBSD 3.5:1:1:1:255:1:255:1:0:255:1:0:255:1:8:255:0:1:1:1:1:1:1:0:1:64:16384:MNNSNWNNT:0:1:1

# Submitted by Dead Jester
OpenBSD 3.2:1:1:1:255:1:255:1:0:255:1:0:255:1:8:255:0:1:1:2:1:>20:1:1:1:64:17280:MNNSNWNNT:0:1:1

OpenBSD 3.1:1:1:1:255:1:255:1:0:255:1:0:255:1:8:255:0:1:1:2:1:>20:1:1:1:64:17376:MNNSNWNNT:0:1:1
OpenBSD 2.9:1:1:1:255:0:255:1:0:255:1:0:255:1:8:255:0:1:2:1:1:>20:1:1:1:64:16992:MNNSNWNNT:0:1:1
OpenBSD 2.7:0:1:0:64:0:64:1:0:64:1:0:64:1:8:255:0:1:2:2:1:>20:1:0:1:64:16500:MNNSNWNNT:0:1:1

# Submitted by Hal Davis - DEC VMS MultiNet V4.2(16)/ OpenVMS V7.1-2
OpenVMS 7.1:1:1:1:255:1:255:1:1:255:1:1:255:1:8:255:1:1:0:0:3:1:3:1:1:64:6144:MNWNNT:0:1:1

# Submitted by Craig Carpenter - OpenVMS 7.1-1H2 running on a HP Alpha 4100
OpenVMS 7.1-1H2:1:1:0:255:1:255:1:1:255:1:1:255:1:8:255:0:1:1:0:3:1:3:0:1:128:3000::N:N:N:

# Submitted by Enno Rey
OpenVMS 7.2:1:1:1:64:1:64:1:0:64:1:1:64:1:8:64:1:1:0:1:1:1:1:0:1:64:33580:MNW:0:N:N

OpenVMS 7.2:1:1:1:64:1:64:1:0:64:1:1:64:1:8:64:1:1:0:1:1:1:1:0:1:64:4380:MNW:0:N:N


# Submitted by H D Moore
OpenVMS:1:1:1:64:1:64:1:0:64:1:1:64:1:8:64:1:1:1:1:1:1:1:0:1:64:61440:MNW:0:N:N

# Submitted by Joe Clifton
OS/2 2.4:1:1:1:64:1:64:1:1:64:1:0:64:1:8:64:1:1:0:0:3:1:3:1:1:64:33580:MNW:0:N:N
OS/2 Warp 4.0 Advanced Server:1:1:1:255:1:255:1:1:255:1:1:255:1:8:255:1:1:0:0:3:1:3:0:1:64:28672:M:N:N:N
OS/2 Warp 4.0 Advanced Server:1:1:1:255:1:255:1:1:255:1:1:255:1:8:255:1:1:0:0:3:1:3:0:1:64:4096:M:N:N:N

OS/2 Warp 4.0:1:1:1:255:1:255:1:1:255:1:1:255:1:8:255:1:1:0:0:3:1:3:0:1:32:27588:M:N:N:N


# Submitted by Maarten Hartsuijker
PacketShaper 4.1:1:1:1:255:1:255:1:1:255:1:1:255:1:8:255:1:1:1:0:1:1:3:0:1:64:4096:M:N:N:N

# Submitted by Daniel Wesemann
PacketShaper 6:1:1:1:255:1:255:1:1:255:1:1:255:1:8:255:1:1:1:0:3:1:3:0:1:64:4096::N:N:N
PacketShaper 6:1:1:1:255:1:255:1:1:255:1:1:255:1:8:255:1:1:1:0:3:1:3:0:1:64:1460::N:N:NA


# Submitted by Shawn Lukaschuk
Perle CONSOLESERVER 9000:1:1:1:255:1:255:1:0:255:1:1:255:1:8:255:1:1:0:0:3:1:3:0:1:64:2048:M:N:N:N

# submited by Kendall Risselada
Phaser 850DP:1:1:0:128:0:128:1:0:128:1:0:128:1:8:128:0:1:1:1:1:1:1:0:1:128:2920:M:N:N:N

# Submitted by Sean Buffington (SoundPoint IP 500)
Polycom SoundPoint IP Phone:1:1:1:64:1:64:1:0:64:1:0:64:1:8:64:1:1:0:0:3:1:3:0:1:64:8192:M:N:N:N

# Submitted by Dirk De Wit
Polycom Viewstation:0:1:1:64:0:64:1:0:64:1:0:64:1:64:64:0:1:1:1:1:1:1:0:1:64:23360:M:N:N:N

# Submitted by Lee Reynolds
Quantum Snap Server:1:1:1:255:0:255:1:0:255:1:0:255:1:8:255:1:1:0:0:3:1:3:0:1:32:8760:M:N:N:N


# Submitted by John Ward
SCO OpenServer 5.0.7:1:1:0:64:1:64:1:0:64:1:0:64:1:8:64:0:1:1:2:1:1:1:0:1:64:33580:M:N:N:N
# Submitted by David Lodge
SCO OpenServer 5.0.6:1:1:1:64:1:64:1:0:64:1:0:64:1:8:64:1:1:1:1:1:1:1:1:1:64:24820:M:N:N:N
# Submitted by Jeff Groves
SCO OpenServer 5.0.6:1:1:0:64:1:64:1:0:64:1:0:64:1:8:64:0:1:1:1:1:1:1:0:1:64:4380:M:N:N:N



# Submitted by Bill Jackson
SCO OpenServer 5.0.5:1:1:0:64:1:64:1:0:64:1:0:64:1:8:64:0:1:1:1:1:1:1:0:1:64:24820:M:N:N:N

# Submitted by Carlo Tognetti
SCO UnixWare 2.1.3:1:1:1:64:1:64:1:0:64:1:0:64:1:8:64:1:1:1:2:3:1:3:0:1:64:4096:M:N:N:N

# Submitted by Michel Arboi
SCO UnixWare 8.0:1:1:0:64:1:64:1:0:64:1:0:64:1:8:64:0:1:1:1:1:1:1:0:1:64:24820:MNWNNT:0:1:1

# Submitted by Michael Scheidell
SonicWall Firewall:1:1:1:64:0:64:1:0:64:1:0:64:1:8:64:1:1:0:0:3:1:3:0:1:64:8192:MNW:0:N:N

# Sumitted by Pauli Borodulin
Sony Contact PCS-1600:1:1:0:64:0:64:1:0:64:1:0:64:1:8:64:0:1:1:1:1:1:1:0:1:64:2144:M:N:N:N
# Submitted by Lee Reynolds
Sony Network Camera SNC-RZ30N:1:1:0:255:0:255:1:0:255:1:0:255:1:8:255:0:1:1:1:1:1:1:0:1:64:8688:MNWNNSNNT:0:1:1

# Submitted by Paul Gibson
Sun RSC Card:1:1:1:64:1:64:1:0:64:1:0:64:1:8:64:1:1:0:0:1:1:1:0:1:64:8192:MNW:0:N:N

# Submitted by Wayne Barber
Sun Solaris 2.5:1:1:1:255:1:255:1:1:255:1:0:255:1:64:255:1:1:1:1:1:1:1:1:1:255:8760:M:N:N:N
# Submitted by Johan Srilden
Sun Solaris 7:1:1:1:255:1:255:1:1:255:1:0:255:1:64:255:1:1:1:1:3:1:1:1:1:255:10136:NNTNWNNSM:0:1:1
# Solaris - by HD Moore
Sun Solaris 7:1:1:1:255:0:255:1:1:255:1:0:255:1:64:255:1:1:1:1:1:1:1:1:1:64:33304:NNTMNWNNS:1:1:1
Sun Solaris 7:1:1:1:255:1:255:1:1:255:1:0:255:1:64:255:1:1:1:1:1:1:1:1:1:255:10136:NNTNWNNSM:0:1:1
Sun Solaris 7:1:1:1:255:1:255:1:1:255:1:0:255:1:64:255:1:1:1:1:1:1:1:1:1:255:10136:NNTNWM:0:1:1
Sun Solaris 8:1:1:1:255:1:255:1:1:255:1:0:255:1:64:255:1:1:1:1:1:1:1:1:1:64:24616:NNTNWNNSM:0:1:1
Sun Solaris 8:1:1:1:255:0:255:1:1:255:1:0:255:1:64:255:1:1:1:1:3:1:1:1:1:64:24616:NNTNWNNSM:0:1:1

# Submitted by Joah Sorliden
Sun Solaris 8:1:1:1:255:1:255:1:1:255:1:0:255:1:64:255:1:1:1:1:3:1:1:1:1:64:24616:NNTNWNNSM:0:1:1

# Sumitted by HoJoToGo
Sun Solaris 8:1:1:1:255:1:255:1:1:255:1:0:255:1:64:255:1:1:1:1:1:1:1:1:1:64:24624:NNTNWNNSM:0:1:1

# Submitted by Pavel Vachek - Solaris 8 + IP filter
Sun Solaris 8:1:1:1:255:0:255:1:0:255:1:0:255:1:8:64:1:1:1:1:1:1:1:1:1:64:24616:NNTNWNNSM:0:1:1

# Submitted by Lee Reynolds
Sun Solaris 8:1:1:1:255:0:255:1:1:255:1:0:255:1:64:255:1:1:1:1:1:1:1:1:1:64:33304:NNTNWNNSM:0:1:1

# Submitted by Abri Du Plooy
Sun Solaris 8:1:1:1:255:0:255:1:1:255:1:0:255:1:64:255:1:1:1:1:3:1:1:1:1:64:33304:NNTNWNNSM:1:1:1

Sun Solaris 8:1:1:1:255:1:255:1:1:255:1:0:255:1:64:255:1:1:1:2:1:1:1:1:1:64:24616:NNTNWNNSM:0:1:1

Sun Solaris 9:1:1:1:255:1:255:1:1:255:1:0:255:1:64:255:1:1:1:1:1:1:1:1:1:64:49232:NNTMNWNNS:0:1:1

Sun Solaris 9:1:1:1:255:1:255:1:1:255:1:0:255:1:64:255:1:1:2:1:1:1:1:1:1:64:49248:NNTMNWNNS:0:1:1

# Submitted by Michael H Busse
Sun Solaris 9:1:1:1:255:0:255:1:1:255:1:0:255:1:64:255:1:1:1:1:1:1:1:1:1:64:49232:NNTMNWNNS:0:1:1


# Submited by H D Moore
Sun Solaris 9 (x86):1:1:1:255:1:255:1:1:255:1:0:255:1:64:255:1:1:1:1:1:1:1:1:1:64:33304:NNTMNWNNS:1:1:1

Sharp Copier Printer:1:1:1:64:0:64:1:0:64:1:0:64:1:64:64:0:1:1:1:1:1:1:0:1:64:2048:M:N:N:N

Tandem:1:1:1:255:1:255:1:1:255:1:1:255:1:8:255:1:1:0:0:1:1:1:0:1:32:8192:MNWNNT:0:1:1

# Submitted by Jim Southwell - Therometer www.sensatronics.com
TempTrax Digital Thermometer:1:1:0:64:0:64:1:0:64:1:0:64:1:8:64:0:1:1:1:1:1:1:0:1:64:0:M:N:N:N

# Submitted by Stephen B Suddeth
Tru64 Unix version 5.1:1:1:1:64:1:64:1:1:64:1:1:64:1:8:64:1:1:1:1:1:1:1:0:1:128:61440:MNW:0:N:N

# Submitted by Paul Lamb
Tru64 Unix version 5.1:1:1:1:64:1:64:1:0:64:1:1:64:1:>64:64:1:1:1:1:1:1:1:0:1:128:61440:MNW:0:N:N


ULTRIX 4.4:1:1:0:255:1:255:1:1:255:1:1:255:1:8:255:0:1:0:0:3:1:3:0:1:64:16384:M:N:N:N


# Submitted by Stuart Halliday
Vigor2600:1:1:0:255:0:255:1:0:255:1:0:255:1:8:255:0:1:1:1:1:1:1:0:1:255:2100:M:N:N:N
Vigor2600:1:1:0:255:0:255:1:0:255:1:0:255:1:8:255:0:1:2:2:1:1:1:0:1:255:2100:M:N:N:N
Vigor2600:1:1:0:255:0:255:1:0:255:1:0:255:1:8:255:0:1:2:1:1:1:1:0:1:255:2100:M:N:N:N
# Submitted by Randy Jones
VxWorks 5.1:1:1:1:64:1:64:1:1:64:1:0:64:1:8:64:1:1:0:0:1:1:1:0:1:64:8192:MNW:0:N:N
# Submitted by Michael Scheidell
VxWorks 5.4:1:1:1:64:1:64:1:0:64:1:0:64:1:8:64:1:1:0:0:3:1:3:0:1:64:8192:MNWNNT:0:1:1
# Submitted by Thomas Karsten Bauer
VxWorks 5.4:1:1:1:64:1:64:1:0:64:1:0:64:1:8:64:1:1:0:0:1:1:1:0:1:64:8192:MNWNNT:0:1:1
# Submitted by Pauli Porodulin
Xerox DocuColor:1:1:1:64:1:64:1:0:64:1:0:64:1:8:64:1:1:0:0:1:1:1:0:1:64:8192:M:N:N:N
";


function make_ttl(ttl)
{
 if ( ttl <= 32 )
	return 32;
else if ( ttl <= 64 )
return 64;
else if ( ttl <= 128 )
return 128;
else return 255;
}


function icmp_echo_probe()
{
id = rand() % 65534;
ip = forge_ip_packet(ip_v:4, ip_hl:5, ip_tos:6, ip_off:IP_DF,ip_len:20,
		ip_p:IPPROTO_ICMP, ip_id:0x4747, ip_ttl:0x40,
		ip_src:this_host());
icmp = forge_icmp_packet(ip:ip, icmp_type:8, icmp_code:123,
		    icmp_seq: id, icmp_id:id);

for ( i = 0 ; i < MAX_RETRIES ; i ++ )
{
filter = "icmp and src host " + get_host_ip() + " and icmp[0:1]=0 and icmp[6:2] = " + id;
reply = send_packet(icmp, pcap_active:TRUE, pcap_filter:filter, pcap_timeout:1);
if ( reply ) break;
}

if ( reply == NULL ) {  exit(0); }

sig = NULL;
code = get_icmp_element(icmp:reply, element:"icmp_code");

if ( code ) sig = ":1";
else sig = ":0";

ipid = get_ip_element(ip:reply, element:"ip_id");
if ( ipid == 0x4747 ) sig += ":S";
else if (ipid != 0) sig += ":1";
else sig += ":0";

tos = get_ip_element(ip:reply, element:"ip_tos");
#sig += ":[01]";
#if ( tos == 0 ) 
#sig += ":0";
#else 
#sig += ":1";

df_bit = get_ip_element(ip:reply, element:"ip_off");
if ( df_bit & IP_DF ) sig += ":1";
else sig += ":0";

ttl = make_ttl(ttl:get_ip_element(ip:reply, element:"ip_ttl"));

sig += ":" + ttl;

return sig;
}


function icmp_timestamp_probe()
{
 id = rand() % 65535;
ip = forge_ip_packet(ip_hl:5, ip_v:4,   ip_off:0,
	     ip_id:0x4343, ip_tos:0, ip_p : IPPROTO_ICMP,
	     ip_len : 20, ip_src : this_host(),
                     ip_ttl : 255);

 icmp = forge_icmp_packet(ip:ip,icmp_type : 13, icmp_code:0,
                          icmp_seq : 1, icmp_id : id);


 filter = "icmp and src host " + get_host_ip() + " and icmp[0:1] = 14 and icmp[4:2] = " + id;
 #display(filter, "\n");
 for ( i = 0 ; i < MAX_RETRIES ; i ++ )
   {
     reply = send_packet(icmp, pcap_active:TRUE, pcap_filter:filter, pcap_timeout:1);
     if ( reply ) break;
   }

 if ( reply == NULL ) 
 {
  sig = ":0:" + ttl + ":1";
  return sig;
 }
 
 sig = ":1";
 ttl = make_ttl(ttl:get_ip_element(ip:reply, element:"ip_ttl"));
 sig += ":" + ttl;

 ipid = get_ip_element(ip:reply, element:"ip_id");
 if ( ipid == 0x4343 ) { sig += ":S"; ip_id_sent = "S"; }
 else if (ipid != 0) { sig += ":1"; ip_id_sent = "1"; }
 else { sig += ":0"; ip_id_sent = "0"; }
 
 
 return sig;
}


function icmp_netmask_probe()
{
  id = rand() % 65535;
  ip = forge_ip_packet(ip_hl:5, ip_v:4,   ip_off:0,
                     ip_id:0x4444, ip_tos:0, ip_p : IPPROTO_ICMP,
                     ip_len : 20, ip_src : this_host(),
                     ip_ttl : 255);
  icmp = forge_icmp_packet(ip:ip,icmp_type : 17, icmp_code:0,
                          icmp_seq : 1, icmp_id : id, data:raw_string(0xFF, 0xFF, 0xFF, 0xFF));

 filter = "icmp and src host " + get_host_ip() + " and icmp[0:1] = 18 and icmp[4:2] = " + id;
 #display(filter, "\n");
 for ( i = 0 ; i < MAX_RETRIES ; i ++ )
   {
     reply = send_packet(icmp, pcap_active:TRUE, pcap_filter:filter, pcap_timeout:1);
     if ( reply ) break;
   }

 if ( reply == NULL ) 
 {
  sig = ":0:" + ttl + ":" + ip_id_sent;
  return sig;
 }
 
 sig = ":1";
 ttl = make_ttl(ttl:get_ip_element(ip:reply, element:"ip_ttl"));
 sig += ":" + ttl;

 ipid = get_ip_element(ip:reply, element:"ip_id");
 if ( ipid == 0x4444 ) { sig += ":S"; ip_id_sent = "S"; }
 else if (ipid != 0) { sig += ":1"; ip_id_sent = "1"; }
 else { sig += ":0"; ip_id_sent = "0"; }
 
 return sig;
}

function icmp_inforeq_probe()
{
  id = rand() % 65535;
  ip = forge_ip_packet(ip_hl:5, ip_v:4,   ip_off:0,
                     ip_id:0x4545, ip_tos:0, ip_p : IPPROTO_ICMP,
                     ip_len : 20, ip_src : this_host(),
                     ip_ttl : 255);
  icmp = forge_icmp_packet(ip:ip,icmp_type : 15, icmp_code:0,
                          icmp_seq : 1, icmp_id : id);

 filter = "icmp and src host " + get_host_ip() + " and icmp[0] = 16 and icmp[4:2] = " + id;
 #display(filter, "\n");
 for ( i = 0 ; i < MAX_RETRIES ; i ++ )
   {
     reply = send_packet(icmp, pcap_active:TRUE, pcap_filter:filter, pcap_timeout:1);
     if ( reply ) break;
   }

 if ( reply == NULL ) 
 {
  sig = ":0:" + ttl + ":" + ip_id_sent;
  return sig;
 }
 
 sig = ":1";
 ttl = make_ttl(ttl:get_ip_element(ip:reply, element:"ip_ttl"));
 sig += ":" + ttl;

 ipid = get_ip_element(ip:reply, element:"ip_id");
 if ( ipid == 0x4545 ) sig += ":S";
 else if (ipid != 0) sig += ":1";
 else sig += ":0";
 
 return sig;
}

function icmp_udpunreach_probe()
{
  local_var i;

  filter = "icmp[30:2] = 42000";
  for ( i = 1 ; i < MAX_RETRIES * 2 ; i ++ )
  {
    filter += " or icmp[30:2] = " + string(42000 + i);
  }

  sig = "";
 filter = "icmp and src host " + get_host_ip() + " and icmp[0] = 3 and (" + filter + ")";


 for ( i = 0 ; i < MAX_RETRIES * 2 ; i ++ )
   {
    ip = forge_ip_packet(ip_v   : 4, ip_hl  : 5, ip_tos : 0, ip_id  : 0x4664, ip_len : 20, ip_off : IP_DF, ip_p   : IPPROTO_UDP, ip_src : this_host(), ip_ttl : 255);
    ip = insstr(ip, raw_string(0x46, 0x64), 4, 5);
    udpip = forge_udp_packet( ip : ip, uh_sport : 53, uh_dport : 42000 + i, uh_ulen :8+128, uh_sum:0, data:crap(128));          

  # Work around a nasl bug.
  reply = send_packet(udpip, pcap_active:TRUE, pcap_filter:filter, pcap_timeout:1);
     if ( reply ) break;
   }
 
 if ( ! reply ) 
 {
  return ":X:X:X:X:X:X:X:X:X:X";
 }

 hl  = get_ip_element(ip:reply, element:"ip_hl");
 len = get_ip_element(ip:reply, element:"ip_len");
 len -= hl * 4 + 8 + 20;

 # udp_echoed_dtsize

 if ( len == 8 ) sig = ":8";
 else if ( len <= 64 ) sig = ":64";
 else sig = ":>64";

 # reply_ttl 
 ttl = make_ttl(ttl:get_ip_element(ip:reply, element:"ip_ttl"));
 sig += ":" + ttl;

 # Precedence bits
 tos = get_ip_element(ip:reply, element:"ip_tos");
 #sig += ":[012]";
 #if ( tos == 0 ) sig += ":0";
 #else if ( tos == 0xc0 ) sig += ":2";
 #else sig += ":1";

 # Unfrag bit
 unfrag = get_ip_element(ip:reply, element:"ip_off");
 if ( unfrag & IP_DF ) sig += ":1";
 else sig += ":0";
 
 # IP ID
 ipid = get_ip_element(ip:reply, element:"ip_id");
 if ( ipid == 0x4664 || ipid == 0x6446) sig += ":S";
 else if (ipid != 0) sig += ":1";
 else sig += ":0";

 # Checksums
 udp = substr(reply, hl * 4 + 8 , strlen(reply) - 1);

 sum = substr(udp, 26, 27);
 udp2 = substr(udp, 20, 25) + raw_string(0,0) + substr(udp, 28, strlen(udp) - 1 );

 pseudo = substr(udp, 12, 19) + raw_string(0, 0x11) + htons(n:strlen(udp) - 20) + udp2;
 
 sum2 = ip_checksum(data:pseudo);
 origsum = substr(udpip, 26,27);
 if ( sum == raw_string(0,0) ) sig += ":0"; 
 else if ( sum == origsum || sum == sum2 ) sig += ":1";
 else sig += ":2";


 sum = get_ip_element(ip:udp, element:"ip_sum");
 udp2 = set_ip_elements(ip:udp, ip_sum:0);
 sum2 = get_ip_element(ip:udp2, element:"ip_sum");
 

 if ( sum == sum2 ) sig += ":1"; 
 else if ( sum == 0 ) sig += ":0";
 else sig += ":2";


 # echoed_ip_id
 ip_id = substr(udp, 4, 5);
 if ( hexstr(ip_id) == "4664" ) sig += ":1";
 else sig += ":3";

 # total_len
 len = get_ip_element(ip:udp, element:"ip_len");
 if ( len == 0x9c || len == 0x9c00 ) sig += ":1";
 else if ( len >= 20) sig += ":>20";
 else sig += ":<20";
 

 # 3bit_flag
 # ????
 off = substr(udp, 6, 7);
 if ( hexstr(off) == "4000" ) sig += ":1";
 else sig += ":3";
 

 return sig;
}


function tcp_synack_probe()
{
 port = get_host_open_port();
 if ( ! port ) {  exit(0); }

 for ( i = 0 ; i < MAX_RETRIES ; i ++ )
 {
 ip = forge_ip_packet(   ip_v : 4,
                        ip_hl : 5,
                        ip_tos : 0x10,
                        ip_len : 20,
                        ip_id : 0x4747,
                        ip_p : IPPROTO_TCP,
                        ip_ttl : 255,
                        ip_off : IP_DF,
                        ip_src : this_host());



  opts = raw_string(2, 4, 1460 / 256, 1460 % 256 );
  opts += raw_string(4, 2);
  time = raw_string(1,2,3,4,5,6,7,8);
  opts += raw_string(8, 10) + time;
  opts += raw_string(1);
  opts += raw_string(3, 3, 0);
  seq   = rand();
  tcpip = forge_tcp_packet(  ip       : ip,
                             th_sport : 4242,
                             th_dport : port,
                             th_flags : TH_SYN,
                             th_seq   : seq,
                             th_ack   : 0,
                             th_x2    : 0,
                             th_off   : (20+strlen(opts))/4,
                             th_win   : 5840,
                             th_urp   : 0, 
			     data     : opts);


     filter = "tcp and src host " + get_host_ip() + " and src port " + port + " and dst port 4242 and ( tcp[13:1] & " + string(TH_SYN|TH_ACK) + " == " + string(TH_SYN|TH_ACK) + " )";
     #display("filter=", filter, "\n");
     reply = send_packet(tcpip, pcap_active:TRUE, pcap_filter:filter, pcap_timeout:1);
     if ( strlen(reply) ) {
 	flag = get_tcp_element(tcp:reply, element:"th_flags");
 	if ( flag & (TH_SYN|TH_ACK) == TH_SYN|TH_ACK) break;
	}
   }
 
 if ( strlen( reply ) == 0 ) { exit(0); }
 
 
 tos = get_ip_element(ip:reply, element:"ip_tos");
 #sig = ":[^:]*"; 
 sig = "";
 #if ( tos == 0 ) sig = ":0";
 #else sig = ":" + hex(tos);


 df = get_ip_element(ip:reply, element:"ip_off");
 if ( df & IP_DF ) sig += ":1";
 else sig += ":0";

 
 ipid = get_ip_element(ip:reply, element:"ip_id");
 if ( ipid == 0x4747 ) sig += ":S";
 else if (ipid != 0) sig += ":1";
 else sig += ":0";

 ttl = make_ttl(ttl:get_ip_element(ip:reply, element:"ip_ttl"));
 sig += ":" + ttl;

 win = get_tcp_element(tcp:reply, element:"th_win");
 sig += ":" + win;
 
 hl = get_ip_element(ip:reply, element:"ip_hl");
 tcpopts = substr(reply, hl * 4 + 20, strlen(reply) - 1);
 
 str = "";
 blank = "";
 for ( i = 0 ; i < strlen(tcpopts); i ++ )
 {
  if ( ord(tcpopts[i]) == 2 ) str +=  "M";
  else if ( ord(tcpopts[i]) == 1 ) str += "N";
  else if ( ord(tcpopts[i]) == 4 ) str += "S";
  else if ( ord(tcpopts[i]) == 3 ) { 
	str += "W";
	wscale = ord(tcpopts[i+2]);
	}
  else if ( ord(tcpopts[i]) == 8 ) {
	str += "T";
	tsval = substr(tcpopts, i + 2, i + 6 );
        tsecr = substr(tcpopts, i + 6, i + 9);
      }
   else if (ord(tcpopts[i]) == 0 ) {  break; }

  if ( ord(tcpopts[i]) != 1 ) i += ord(tcpopts[i+1]) - 1;
 }
 
 sig += ":" + str;

 if ( !isnull(wscale) )
 {
  sig += ":" + wscale;
 }
 else sig += ":N";

 if ( tsval )
 {
 if( hexstr(tsval) >< "0000000000" ) sig += ":0";
 else sig += ":1";
 }
 else sig += ":N";
 
 if ( tsecr )
 {
 if( hexstr(tsecr) >< "0000000000" ) sig += ":0";
 else sig += ":1";
 }
 else sig += ":N";
 
  
 return sig;
}

#-------------------------------------------------------------------------------------------------#
# DCOM_RECV											  							  				  #
#-------------------------------------------------------------------------------------------------#
function dcom_recv(socket)
{
 local_var buf, len;
 
 buf = recv(socket:socket, length:9);
 if(strlen(buf) != 9)return NULL;
 
 len = ord(buf[8]);
 buf += recv(socket:socket, length:len - 9);
 return buf;
}

#-------------------------------------------------------------------------------------------------#
# CHECK_WINOS 	- KK Liu	
# Updated 8/25/2004	- check kb first for WinOS identification		  							  #
# Updated 11/04/2004- add XP sp2 identification						  							  #
#-------------------------------------------------------------------------------------------------#
function check_winos()
{
    kb = get_kb_item("Host/OS/smb");
    if ( kb ) 
    {
       name = NULL;
       if ("Windows 4.0" >< kb  ) { flag = 0; name = "Microsoft Windows NT 4.0"; }
       if ("Windows 5.0" >< kb  ) { flag = 0; name = "Microsoft Windows 2000"; }
       if ("Windows 5.0 Server" >< kb  ) { flag = 0; name = "Microsoft Windows 2000 Server"; }
       if ("Windows 5.1" >< kb  ) { 
         	if (check_XP_SP2() == 1) name = "Microsoft Windows XP SP2";
        	else name = "Microsoft Windows XP";  
       		flag = 0;
       }
       if ("Windows 5.2" >< kb || "Windows Server 2003" >< kb ) { flag = 0; name = "Microsoft Windows 2003 Server"; }

		if ( name ) 
		{
				report = "The remote host is running " + name;
				set_kb_item(name:"Host/OS/icmp", value:name);
				security_note(port:0, data: report );
				exit(0);
		}
    }

	# SMB failed to id the OS, attempt RPC 
	port = 135;
	chk = raw_string (0x02,0x00,0x01,0x00);

	bindwinme = raw_string(
	0x05,0x00,0x0b,0x03,0x10,0x00,0x00,0x00,0x48,0x00,0x00,0x00,0x53,0x53,0x56,0x41,
	0xd0,0x16,0xd0,0x16,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x01,0x00,
	0xe6,0x73,0x0c,0xe6,0xf9,0x88,0xcf,0x11,0x9a,0xf1,0x00,0x20,0xaf,0x6e,0x72,0xf4,
	0x02,0x00,0x00,0x00,0x04,0x5d,0x88,0x8a,0xeb,0x1c,0xc9,0x11,0x9f,0xe8,0x08,0x00,
	0x2b,0x10,0x48,0x60,0x02,0x00,0x00,0x00
	);


	if ( get_port_state(port) )
	{
    	soc = open_sock_tcp(port);
	if(soc)
	{
	    send(socket:soc,data:bindwinme);
        rwinme  = dcom_recv(socket:soc);
        if(!strlen(rwinme))exit(0);
	    lenwinme = strlen(rwinme);
	    stubwinme = substr(rwinme, lenwinme-24, lenwinme-21);
	    if (debug)
	    {
	    	display('len = ', lenwinme, '\n');
			display('stub  = ', hexstr(stubwinme), '\n');
			display('r = ', hexstr(rwinme), '\n');
	    }
	    if (stubwinme >< chk)
	    {
		return 0; # Conflicts with HP/UX...
	    	version = "Microsoft Windows 95/98/ME";
	    	if (debug) display(version,'\n');
			report = "The remote host is running " + version;
			set_kb_item(name:"Host/OS/icmp", value:version);
			security_note(port:0, data: report );
			close(soc);
			exit(0);
        }
	    check_NT2K(soc:soc);
	}
	}


}

#-------------------------------------------------------------------------------------------------#
# IS_SERVER	- KK Liu
#-------------------------------------------------------------------------------------------------#
function is_Server()
{
	SRVchk = raw_string (0xFD,0xF3);
	multiplex_id = rand();
	g_mhi = multiplex_id / 256;
	g_mlo = multiplex_id % 256;
	port = 445;
	neg_prot = raw_string
	   	(
		 0x00, 0x00, 0x00, 0xA4, 0xFF, 0x53,
		 0x4D, 0x42, 0x72, 0x00, 0x00, 0x00, 0x00, 0x08,
		 0x01, 0xC8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		 0x40, 0x06, 0x00, 0x00, g_mlo, g_mhi, 0x00, 0x81,
		 0x00, 0x02
		 ) + "PC NETWORK PROGRAM 1.0" + raw_string(0x00, 0x02) +
		 "MICROSOFT NETWORKS 1.03" + raw_string(0x00, 0x02) + 
		 "MICROSOFT NETWORKS 3.0"  + raw_string(0x00, 0x02) + 
		 "LANMAN1.0" + raw_string(0x00, 0x02) + 
		 "LM1.2X002" + raw_string(0x00, 0x02) + 
		 "Samba" +     raw_string(0x00, 0x02) +
		 "NT LANMAN 1.0" + raw_string(0x00, 0x02) +
		 "NT LM 0.12" + raw_string(0x00);

	if (debug) display('Server check .....\n');
    soc = open_sock_tcp(port);
	if(soc)
	{
		send(socket:soc, data:neg_prot);
		r = smb_recv(socket:soc, length:4000);
		if(strlen(r) < 38)return(NULL);

        if(!strlen(r))exit(0);
       	stub = substr(r, 56, 57);
       	if (debug)
	    {
			display('stub  = ', hexstr(stub), '\n');
			display('r = ', hexstr(r), '\n');
	    }

       	if (stub >< SRVchk) # check XP vs. 2003
       	{ 
	    	close(soc);
	    	return (1);
	    }
	}
	return (0);
}

#-------------------------------------------------------------------------------------------------#
# CHECK_NT2K - KK Liu											  							      #
# Updated 11/04/2004- add XP sp2 identification						  							  #
#-------------------------------------------------------------------------------------------------#
function check_NT2K(soc)
{
	XPchk = raw_string (0x00,0x00,0x00,0x00);
	
	NT2Ktest = raw_string( 
	0x05, 0x00, 0x0b, 0x03, 0x10, 0x00, 0x00, 0x00,
	0xcc, 0x00, 0x00, 0x00, 0x84, 0x67, 0xbe, 0x18,
	0x31, 0x14, 0x5c, 0x16, 0x00, 0x00, 0x00, 0x00,
	0x04, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
	0xb8, 0x4a, 0x9f, 0x4d, 0x1c, 0x7d, 0xcf, 0x11,
	0x86, 0x1e, 0x00, 0x20, 0xaf, 0x6e, 0x7c, 0x57,
	0x00, 0x00, 0x00, 0x00, 0x04, 0x5d, 0x88, 0x8a,
	0xeb, 0x1c, 0xc9, 0x11, 0x9f, 0xe8, 0x08, 0x00,
	0x2b, 0x10, 0x48, 0x60, 0x02, 0x00, 0x00, 0x00,
	0x02, 0x00, 0x01, 0x00, 0xa0, 0x01, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x46, 0x00, 0x00, 0x00, 0x00,
	0x04, 0x5d, 0x88, 0x8a, 0xeb, 0x1c, 0xc9, 0x11,
	0x9f, 0xe8, 0x08, 0x00, 0x2b, 0x10, 0x48, 0x60,
	0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x01, 0x00,
	0x0a, 0x42, 0x24, 0x0a, 0x00, 0x17, 0x21, 0x41,
	0x2e, 0x48, 0x01, 0x1d, 0x13, 0x0b, 0x04, 0x4d,
	0x00, 0x00, 0x00, 0x00, 0x04, 0x5d, 0x88, 0x8a,
	0xeb, 0x1c, 0xc9, 0x11, 0x9f, 0xe8, 0x08, 0x00,
	0x2b, 0x10, 0x48, 0x60, 0x02, 0x00, 0x00, 0x00,
	0x04, 0x00, 0x01, 0x00, 0xb0, 0x01, 0x52, 0x97,
	0xca, 0x59, 0xcf, 0x11, 0xa8, 0xd5, 0x00, 0xa0,
	0xc9, 0x0d, 0x80, 0x51, 0x00, 0x00, 0x00, 0x00,
	0x04, 0x5d, 0x88, 0x8a, 0xeb, 0x1c, 0xc9, 0x11,
	0x9f, 0xe8, 0x08, 0x00, 0x2b, 0x10, 0x48, 0x60,
	0x02, 0x00, 0x00, 0x00);

	if (debug) display('NT 2K check -----\n');

	    send(socket:soc,data:NT2Ktest);
        r  = dcom_recv(socket:soc);
        if(!strlen(r))exit(0);
             
	    len = strlen(r);
       	if (debug)
	    {
	    	display('len = ', len, '\n');
			display('r = ', hexstr(r), '\n');
	    }
	    
	    if (len == 132)
	    {
	    	version = "Microsoft Windows NT 4.0";
	    	if (debug) display(version,'\n');
			report = "The remote host is running " + version;
			set_kb_item(name:"Host/OS/icmp", value:version);
			security_note(port:0, data: report );
        }
        else
        {
        	stub = substr(r, 20, 23);
	       	if (debug)
		    {
		    	display('len = ', len, '\n');
				display('stub = ', hexstr(stub), '\n');
		    }
        	
        	if (stub >< XPchk) # check if XP, 2003
        	{
        		if (is_Server()==1) version = "Microsoft Windows 2003";
        		else {
        			if (check_XP_SP2() == 1) version = "Microsoft Windows XP SP2";
        			else version = "Microsoft Windows XP";  
        			
        		}    		
        	}
        	# identify Win2K server vs. workstation
        	else 
        	{
        		if (is_Server()==1) version = "Microsoft Windows 2000 Server";
        		else version = "Microsoft Windows 2000 Professional";
        	}
	    	if (debug) display(version,'\n');
			report = "The remote host is running " + version;
			set_kb_item(name:"Host/OS/icmp", value:version);
			security_note(port:0, data: report );       	 	
        }
	    close(soc);
	    exit(0);
}

#-------------------------------------------------------------------------------------------------#
# CHECK_XP_SP2 - KK Liu 2004-11-05											  							      #
#-------------------------------------------------------------------------------------------------#
function check_XP_SP2()
{
	#debug = 1;
	port = 135;
	sp2chk = raw_string(0x05,0x00,0x00,0x00,0x00,0x00,0x00,0x00);
	acceptance = raw_string(0x00,0x00);
	
	bind = raw_string (
	0x05,0x00,0x0b,0x03,0x10,0x00,0x00,0x00,0x48,0x00,0x00,0x00,0x01,0x00,0x00,0x00,
	0xd0,0x16,0xd0,0x16,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x01,0x00,
	0x08,0x83,0xaf,0xe1,0x1f,0x5d,0xc9,0x11,0x91,0xa4,0x08,0x00,0x2b,0x14,0xa0,0xfa,
	0x03,0x00,0x00,0x00,0x04,0x5d,0x88,0x8a,0xeb,0x1c,0xc9,0x11,0x9f,0xe8,0x08,0x00,
	0x2b,0x10,0x48,0x60,0x02,0x00,0x00,0x00	
	);
	
	
	EPquery = raw_string( 
	0x05,0x00,0x00,0x03,0x10,0x00,0x00,0x00,0x64,0x00,0x00,0x00,0x01,0x00,0x00,0x00,
	0x4c,0x00,0x00,0x00,0x00,0x00,0x02,0x00,
	0x03,0x00,0x00,0x00, 
	0x01,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x02,0x00,0x00,0x00,
	0x78,0x57,0x34,0x12,0x34,0x12,0xcd,0xab,0xef,0x00,0x01,0x23,0x45,0x67,0x89,0xac, 
	0x73,0x2b,0x40,0x00,
	0x01,0x00,0x00,0x00, 
	0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x01,0x00,0x00,0x00
);

	if (debug) display('XP sp2 check -----\n');

	if ( get_port_state(port) )
	{
    	soc = open_sock_tcp(port);
		if(soc)
		{
	
		    send(socket:soc,data:bind);
	        r  = dcom_recv(socket:soc);
	        if(!strlen(r)) return(0);
	        #check if acceptance
		    len = strlen(r);
        	stub = substr(r, len-24, len-23);
        	if (stub >!< acceptance) # check if SP2
        	{     		
        		return (0);     		
        	}
        	
        	        	    
	       	if (debug)
		    {
		    	len = strlen(r);
		    	display('len = ', len, '\n');
				display('r = ', hexstr(r), '\n');
		    }
		    
		    send(socket:soc,data:EPquery);
	        r  = dcom_recv(socket:soc);
	        if(!strlen(r)) return(0);
	        close(soc);
	        
		    len = strlen(r);
        	stub = substr(r, len-8, len-1);
	       	if (debug)
		    {
		    	display('len = ', len, '\n');
				display('stub = ', hexstr(stub), '\n');
		    }
        	
        	if (stub >< sp2chk) # check if SP2
        	{     		
        		return (1); # SP2     		
        	}
      	 	
		}
	}
	close(soc);
	return(0);
}

#-------------------------------------------------------------------------------------------------#
# MAIN 												  #
#-------------------------------------------------------------------------------------------------#

if ( islocalhost() ) exit(0);

# check windows os using RPC + neg - by KK Liu
check_winos();

mysig = icmp_echo_probe() + icmp_timestamp_probe() + icmp_netmask_probe() + icmp_inforeq_probe() + icmp_udpunreach_probe() + tcp_synack_probe();




os = egrep(pattern:mysig, string:db);


if ( os )
{
 os = split(os);
 name = "";
 flag = 0;
 foreach os_name (os)
 {
 tmp = split(os_name, sep:":", keep:0);
 if ( strlen(name) == 0 )
	name = tmp[0];
 else
	{
	name += '\n' + tmp[0];
	flag ++;
	}
 }

 if ( strlen ( name ) ) 
 {

  if ( egrep(pattern:".*Windows.*", string:name) )
  {
  }
 if ( ! flag ) 
	report = "The remote host is running " + name;
 else 
	report = "The remote host is running one of these operating systems : " + '\n' + name;


 set_kb_item(name:"Host/OS/icmp", value:name);

 security_note(port:0, data:report);
 exit(0);
 }
}

if( "X:X:X:X:X:X" >< mysig) {  exit(0); }

results = split(mysig, sep:":", keep:0);
db = egrep(pattern:"^[^#].*", string:db);

foreach sig (split(db))
{
 sig = sig - '\n';
 if ( strlen(sig) > 1 )
 {
 v = split(sig, sep:":", keep:0);
 n = max_index(v);
 os = v[0];
 diff = 0;
 window = 0;
 for ( i = 1; i < n ; i ++ )
   {
   if ( v[i] != results[i] ) diff ++;
   if ( i == 26 ) window ++;
   }

 differences[os] = diff;
 windows[os] = window;
 
 }
}

m = 999999;
foreach d (differences)  if ( d < m ) m = d;


if ( m < 10 )
{

os = NULL;
count = 0;

foreach i (keys(differences))
{
 if ( differences[i] == m )
  {
   if( ! os ) { os = i; count = 1; }
   else { os += '\n' + i; count ++ ; }
  }
}

if ( count == 1 && m == 1 && windows[os] == 1)
{
	report = "The remote host is running " + os;
 	security_note(port:0, data:report);
 	set_kb_item(name:"Host/OS/icmp", value:name);
	exit(0);
}

report = 'Nessus was not able to reliably identify the remote operating system. It might be:\n' + 
 os + '\nThe fingerprint differs from these known signatures on ' + m + ' points.\n' +
 'If you know what operating system this host is running, please send this signature to\n' +
 'os-signatures@nessus.org : \n' + mysig; 

 security_note(port:0, data:report);
 exit(0);
}




report = "The remote host operating system could not be identified. If you know what this server
is running please send this signature to os-signatures@nessus.org : 
" + mysig;
security_note(port:0, data:report);
