#
# Copyright (C) 2004 Tenable Network Security 
#
#

if(description)
{
 script_id(12017);
 script_version("$Revision: 1.2 $");

 name["english"] = "NCASE detection";

 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is using the NCASE program.  
You should ensure that:
- the user intended to install NCASE (it is sometimes silently installed)
- the use of NCASE matches your corporate mandates and security policies.

To remove this sort of software, you may wish to check out ad-aware or spybot. 

See also : http://pestpatrol.com/PestInfo/n/ncase.asp 
Solution : Uninstall this software
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "NCASE detection";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Windows";
 script_family(english:family["english"]);
 
 script_dependencies("smb_registry_full_access.nasl");
 script_require_keys("SMB/registry_full_access");

 script_require_ports(139, 445);
 exit(0);
}


# start the script


if ( !get_kb_item("SMB/registry_full_access") ) exit(0);

path[0] = "clsid\{2bc43670-c0bd-4794-bb11-f60f3e001dc5}";
path[1] = "clsid\{6eb5b540-1e74-4d91-a7f0-5b758d333702}";
path[2] = "software\microsoft\code store database\distribution units\{6eb5b540-1e74-4d91-a7f0-5b758d333702}";
path[3] = "software\microsoft\windows\currentversion\uninstall\msbb";
path[4] = "software\microsoft\windows\currentversion\uninstall\ncase";
path[5] = "typelib\{6eb5b540-1e74-4d91-a7f0-5b758d333702}";



include("smb_nt.inc");

for (i=0; path[i]; i++) {
       val = registry_key_exists(key:path[i]);
       if(val != NULL) {security_hole(kb_smb_transport()); exit(0); } 
}


