#
# (C) Tenable Network Security
#
# The plugin description is (C) Jacques Vidrine and contributors. 
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(15814);
 script_version ("$Revision: 1.1 $");
 script_bugtraq_id ( 11668 );
 name["english"] = "FreeBSD Ports : sudo < 1.6.8.2";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has one of the following packages installed :

sudo < 1.6.8.2

A flaw in exists in sudo's environment sanitizing prior  to sudo version 
1.6.8p2 that could allow a malicious user with permission to run a shell 
script that utilized the  bash shell to run arbitrary commands.

See also : http://www.courtesan.com/sudo/alerts/bash_functions.html
Solution : http://www.vuxml.org/freebsd/bdd1537b-354c-11d9-a9e7-0001020eed82.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the sudo package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^sudo-[01]", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"sudo-1.6.8.2") < 0  )
	{
	security_hole(0);
	exit(0);
	}
