#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12618);
 script_bugtraq_id(10386);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2004-0397");
 name["english"] = "FreeBSD Ports : subversion < 1.0.2_1";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has a version of the subversion package which is older 
than 1.0.2_1.

subversion is a source versionning system, akin to cvs. There is a bug in the
remote version of this package in the way it parses dates, which may allow
an attacker to execute arbitrary code on the remote host.

Solution : http://www.vuxml.org/freebsd/5d36ef32-a9cf-11d8-9c6d-0020ed76ef5a.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the subversion package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");

pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^subversion-", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"subversion-1.0.2_1") < 0 ) 
        {
        security_hole(0);
        exit(0);
        }
