#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12616);
 script_bugtraq_id(10500);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2004-0541");
 name["english"] = "FreeBSD Ports: squid < 2.5.5_9";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has a version of squid installed which is older than 2.5.5_9.

Squid is a Web proxy cache. There is a bug in the remote version of this
package in the way it handles NTLM authentication, which may allow an
attacker to execute arbitrary code on the remote host by sending a
specially crafted NTLM authentication request.


Solution : http://www.vuxml.org/freebsd/6f955451-ba54-11d8-b88c-000d610a3b12.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the squid package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^squid-", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"squid-2.5.5_9") < 0 ) 
	security_hole(0);
