#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(14720);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CAN-2004-0807", "CAN-2004-0808");
 name["english"] = "FreeBSD Ports: Samba3 < 3.0.7_1";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has a version of Samba installed which is older than 3.0.7_1

Samba provides file and printer sharing services to SMB/CIFS clients. 

There is a bug in the remote smbd ASN.1 parsing, which may allow an attacker
to cause a denial of service attack against the remote host by sending
a specially crafted ASN.1 packet during the authentication request which
may make the newly-spawned smbd process run into an infinite loop. By
establishing multiple connections and sending such packets, an attacker
may consume all the CPU and memory of the remote host, thus crashing it
remotely.

Another bug may allow an attacker to crash the remote nmbd process by
sending a malformed NetBIOS packet.


Solution : http://www.vuxml.org/freebsd/a711de5c-05fa-11d9-a9b2-00061bc2ad93.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the Samba packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^samba3-3", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"samba3-3.0.7_1") < 0 ) 
	{
	security_warning(0);
	}
