#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(15577);
 script_version ("$Revision: 1.1 $");
 name["english"] = "FreeBSD Ports : rssh <= 2.2.1";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an installed version of the rssh package which is older
than or as old as version 2.2.1.

There is a format string issue in the remote version of this package which
may allow an attacker to execute arbitrary code from an account which would
otherwise run in a restricted way.


See also : http://www.pizzashack.org/rssh/security.shtml
Solution : http://www.vuxml.org/freebsd/1f826757-26be-11d9-ad2d-0050fc56d258.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the rssh package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^rssh-", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"rssh-2.2.1") <= 0 ) 
	security_hole(0);
