#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(14814);
 script_bugtraq_id(10574);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CAN-2004-0609");
 name["english"] = "FreeBSD Ports : rssh < 2.2.1";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an installed version of the rssh package which is older
than 2.2.1.

rssh is vulnerable to a flaw which may make it vulnerable to a file name 
disclosure issue.

See also : http://marc.theaimsgroup.com/?l=bugtraq&m=108787373022844
Solution : http://www.vuxml.org/freebsd/a4815970-c5cc-11d8-8898-000d6111a684.html
Risk factor : Low";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the rssh package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^rssh-", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"rssh-2.2.1") < 0 ) 
	security_warning(0);
