#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12607);
 script_bugtraq_id(9416, 9417);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2004-0164");
 name["english"] = "FreeBSD Ports: racoon < 20040116a";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of racoon installed.

racoon is an IPSec IKE daemon. There is a flaw in the remote version of racoon
which may allow an attacker to delete security associations, which in turn
may result in a denial of service or cause sensitive traffic to be
transmitted in plaintext.

Solution : http://www.vuxml.org/freebsd/739bb51d-7e82-11d8-9645-0020ed76ef5a.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the racoon package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^racoon-", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"racoon-20040116a") < 0 ) 
	security_hole(0);
