#
# (C) Tenable Network Security
#
# The plugin description is (C) Jacques Vidrine and contributors. 
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(15809);
 script_version ("$Revision: 1.1 $");
 name["english"] = "FreeBSD Ports : putty < 0.56";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has one of the following packages installed :

putty < 0.56

There is a bug in SSH2 support that allows a server to execute  malicious 
code on a connecting PuTTY client.  This attack can be performed before host 
key verification happens,  so a different machine -- man in the middle 
attack -- could fake  the machine you are connecting to.

Solution : http://www.vuxml.org/freebsd/19518d22-2d05-11d9-8943-0050fc56d258.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the wzdftpd package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^putty-0\.", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"putty-0.56") < 0  )
	{
	security_hole(0);
	exit(0);
	}
