#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12594);
 script_version ("$Revision: 1.2 $");
 name["english"] = "FreeBSD Ports: phpBB <= 2.0.8_2";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of phpBB installed.

phpBB is a PHP-based bulletin board system. The script common.php in phpBB
always trusts the 'X-Forwarded-For' header in the client's HTTP request, which
could allow a user to bypass any ACLs set in place.

Solution : http://www.vuxml.org/freebsd/cfe17ca6-6858-4805-ba1d-a60a61ec9b4d.html
Risk factor : Low";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the phpBB package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^phpbb-", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"phpbb-2.0.8_3") < 0 ) 
	security_warning(0);
