#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12579);
 script_bugtraq_id(10568);
 script_version ("$Revision: 1.3 $");
 if ( defined_func("script_xref") ) script_xref(name:"OSVDB", value:"6704");
 name["english"] = "FreeBSD Ports: moinmoin < 1.2.2";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has a version of moinmoin installed which is older than 1.2.2 

MoinMoin is a Wiki-type program written in python. There is a bug 
in the remote version of this software which may allow a user to create
a group which will inherit privileges from an administrative group.

Solution : http://www.vuxml.org/freebsd/da9e6438-bfc0-11d8-b00e-000347a4fa7d.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the moimoin package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^moinmoin-", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"moinmoin-1.2.2") < 0 ) 
	security_hole(0);
