#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(15866);
 script_bugtraq_id(11726);
 script_cve_id("CAN-2004-1029");
 script_version ("$Revision: 1.1 $");
 name["english"] = "FreeBSD Ports: Security Vulnerability With Java Plugin ";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has one of the following package(s) installed :

1.4.0 <= jdk <= 1.4.2p6_6
1.3.0 <= jdk <= 1.3.1p9_4
1.4.0 <= linux-sun-jdk <= 1.4.2.05
1.3.0 <= linux-sun-jdk <= 1.3.1.12
1.3.0 <= linux-blackdown-jdk <= 1.4.2
1.3.0 <= linux-ibm-jdk <= 1.4.2

The Sun Java Plugin capability in Java 2 Runtime Environment  (JRE) 1.4.2_01, 1.4.2_04, 
and possibly earlier versions, does  not properly restrict access between Javascript and 
Java applets during data transfer, which allows remote attackers to load unsafe classes 
and execute arbitrary code.

Solution : http://www.vuxml.org/freebsd/ac619d06-3ef8-11d9-8741-c942c075aa41.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the jdk packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^jdk-1\.4", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"jdk-1.4.0") >= 0 && 
                pkg_cmp(pkg:package, reference:"jdk-1.4.2p6_6") <= 0 ) 
	{
		security_hole(0);
		exit(0);
	}
package = egrep(pattern:"^jdk-1\.3", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"jdk-1.3.0") >= 0 && 
                pkg_cmp(pkg:package, reference:"jdk-1.3.1p9_4") <= 0 ) 
	{
		security_hole(0);
		exit(0);
	}
package = egrep(pattern:"^linux-sun-jdk-1\.3", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"linux-sun-jdk-1.3.0") >= 0 && 
                pkg_cmp(pkg:package, reference:"linux-sun-jdk-1.3.1.12") <= 0 ) 
	{
		security_hole(0);
		exit(0);
	}
package = egrep(pattern:"^linux-sun-jdk-1\.4", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"linux-sun-jdk-1.4.0") >= 0 && 
                pkg_cmp(pkg:package, reference:"linux-sun-jdk-1.4.2.05") <= 0 ) 
	{
		security_hole(0);
		exit(0);
	}
package = egrep(pattern:"^linux-blackdown-jdk-1\.[34]\.", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"linux-blackdown-jdk-1.3.0") >= 0 && 
                pkg_cmp(pkg:package, reference:"linux-blackdown-jdk-1.4.2") <= 0 ) 
	{
		security_hole(0);
		exit(0);
	}
package = egrep(pattern:"^linux-ibm-jdk-1\.[34]\.", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"linux-ibm-jdk-1.3.0") >= 0 && 
                pkg_cmp(pkg:package, reference:"linux-ibm-jdk-1.4.2") <= 0 ) 
	{
		security_hole(0);
		exit(0);
	}
