#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(15492);
 script_version ("$Revision: 1.1 $");
 name["english"] = "FreeBSD Ports : imp < 3.2.6";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has a version of the 'imp' package which is older than 
version 3.2.6.

IMP is a webmail system.

Older versions of this software contains several input validation flaws which
may result in cross-site scripting attacks against the remote host.

Solution : http://www.vuxml.org/freebsd/efc4819b-0b2d-11d9-bfe1-000bdb1444a4.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the imp package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");

pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^imp-[0-3]", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"imp-3.2.6") < 0 ) 
        {
        security_warning(0);
        exit(0);
        }
