#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(14589);
 script_bugtraq_id(11084);
 script_cve_id("CAN-2004-0817", "CAN-2004-0802");
 name["english"] = "FreeBSD Ports : imlib < 1.9.14_3";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of the imlib package which is
older than version 1.9.14_3

imlib an image manipulation library. There is a heap overflow
in the remote version of this package when it processes a specially
crafted BMP file. An attacker may exploit this flaw to execute arbitrary
code on the remote host.

To exploit this flaw, an attacker would need to craft a malformed image
file and to send it to a victim on the remote host, and have the victim
open the file with an imlib-enabled software.

Solution : http://www.vuxml.org/freebsd/00644f03-fb58-11d8-9837-000c41e2cdad.html
Risk Factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the imlib package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");

pkgs = get_kb_item("Host/FreeBSD/pkg_info");
if ( ! pkgs ) exit(0);

package = egrep(pattern:"^imlib-", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"imlib-1.9.14_3") < 0 ) 
        {
        security_hole(0);
        exit(0);
        }
