#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12548);
 script_bugtraq_id(9406);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2004-0097");
 name["english"] = "FreeBSD Ports : Vulnerabilities in H.323 implementations";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has old versions of some or all of the following packages:

 pwlib < 1.5.0_5
 asterisk < 0.7.2
 openh323 < 1.12.0_4

These packages implement the H.323 protocol and are vulnerable to several
security issues which may be exploited by an attacker to execute arbitrary
code on the remote host.
Solution : http://www.vuxml.org/freebsd/27c331d5-64c7-11d8-80e3-0020ed76ef5a.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of several packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
package = egrep(pattern:"^pwlib-", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"pwlib-1.5.0_5") < 0 ) 
	{
	security_hole(0);
	exit(0);
	}
package = egrep(pattern:"^asterisk-", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"asterisk-0.7.2") < 0 ) 
	{
	security_hole(0);
	exit(0);
	}
package = egrep(pattern:"^openh323-", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"openh323-1.12.0_4") < 0 ) 
	{
	security_hole(0);
	exit(0);
	}
