#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(15491);
 script_version ("$Revision: 1.1 $");
 name["english"] = "FreeBSD Ports : gnutls < 1.0.17";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has a version of the 'gnutls' package which is older than 
version 1.0.17 or a version of the 'gnutls-devel' package which is older
than version 1.1.12.

GNU TLS is a SSL library, akin to OpenSSL.

Older versions of this software contains a problem in the certificate chain
verification procedures which may result in a Denial of Service.

Solution : http://www.vuxml.org/freebsd/84ab58cf-e4ac-11d8-9b0a-000347a4fa7d.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the gnutls package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");

pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^gnutls-1.0", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"gnutls-1.0.17") < 0 ) 
        {
        security_warning(0);
        exit(0);
        }
package = egrep(pattern:"^gnutls-devel-1.1", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"gnutls-devel-1.1.12") < 0 ) 
        {
        security_warning(0);
        exit(0);
        }
