#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(15488);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CAN-2004-0601");
 name["english"] = "FreeBSD Ports : distcc < 2.16";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has version of the 'distcc' package which is older than version
2.16.

There is a flaw in the remote version of this package which may cause 
IP-based access control rules to be bypassed on 64bits architectures.

Solution : http://www.vuxml.org/freebsd/e8d4800f-1547-11d9-90a3-00010327614a.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the distcc package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");

pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^distcc", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"distcc-2.16") < 0 ) 
        {
        security_hole(0);
        exit(0);
        }
