#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12526);
 script_bugtraq_id(9115);
 script_version ("$Revision: 1.4 $");
 script_cve_id("CAN-2003-0914");
 name["english"] = "FreeBSD Ports : bind8 negative cache poison attack";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of FreeBSD which contains a bug in bind.

bind is domain name server. A programming error in the remote version of this
package can result in a DNS message being incorrectly cached as a negative
response. As a result, an attacker may arrange for malicious DNS messages to be
delivered to a target name server, and cause that name server to cache a negative
response for that domain name. The name server would then respond negatively
to legitimate requests for the same domain, resulting in a denial of service.

Solution : http://www.vuxml.org/freebsd/f04cc5cb-2d0b-11d8-beaf-000a95c4d922.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the bind package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^bind.*-8\.3", string:pkgs);
if ( package )
{
if ( pkg_cmp(pkg:package, reference:"bind8-8.3.7_1") < 0 ) 
	{
	security_warning(0);
	exit(0);
	}
}

package = egrep(pattern:"^bind.*-8\.4", string:pkgs);
if ( package )
{
if ( pkg_cmp(pkg:package, reference:"bind8-8.4.3_1") < 0 ) 
	{
	security_warning(0);
	exit(0);
	}
}

package = get_kb_item("Host/FreeBSD/release");

if ( egrep(pattern:"FreeBSD-4\.4", string:package) )
{
 if ( pkg_cmp(pkg:package, reference:"FreeBSD-4.4_47") < 0 )
 {
  security_warning(port);
  exit(0);
 }
}

if ( egrep(pattern:"FreeBSD-4\.5", string:package) )
{
 if ( pkg_cmp(pkg:package, reference:"FreeBSD-4.5_37") < 0 )
 {
  security_warning(port);
  exit(0);
 }
}

if ( egrep(pattern:"FreeBSD-4\.6", string:package) )
{
 if ( pkg_cmp(pkg:package, reference:"FreeBSD-4.6.2_27") < 0 )
 {
  security_warning(port);
  exit(0);
 }
}

if ( egrep(pattern:"FreeBSD-4\.7", string:package) )
{
 if ( pkg_cmp(pkg:package, reference:"FreeBSD-4.7_24") < 0 )
 {
  security_warning(port);
  exit(0);
 }
}

if ( egrep(pattern:"FreeBSD-4\.8", string:package) )
{
 if ( pkg_cmp(pkg:package, reference:"FreeBSD-4.8_14") < 0 )
 {
  security_warning(port);
  exit(0);
 }
}

if ( egrep(pattern:"FreeBSD-4\.9", string:package) )
{
 if ( pkg_cmp(pkg:package, reference:"FreeBSD-4.9_1") < 0 )
 {
  security_warning(port);
  exit(0);
 }
}

if ( egrep(pattern:"FreeBSD-5\.0", string:package) )
{
 if ( pkg_cmp(pkg:package, reference:"FreeBSD-5.0_19") < 0 )
 {
  security_warning(port);
  exit(0);
 }
}

if ( egrep(pattern:"FreeBSD-5\.1", string:package) )
{
 if ( pkg_cmp(pkg:package, reference:"FreeBSD-5.1_11") < 0 )
 {
  security_warning(port);
  exit(0);
 }
}
