#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(15575);
 script_version ("$Revision: 1.1 $");
 script_bugtraq_id(11094, 11154);
 script_cve_id("CAN-2004-0748", "CAN-2004-0751");
 name["english"] = "FreeBSD Ports : Apache < 2.0.51";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an installed version of the Apache 2.0 package which is
older than 2.0.51

There are two security issues in the remote version of the mod_ssl module
of this port :

- A segmentation fault may be triggered by a malicious remote server, provided
the proxying to SSL servers has been configured

- A potential infinite loop in mod_ssl may be triggered


Solution : http://www.vuxml.org/freebsd/7b81fc47-239f-11d9-814e-0001020eed82.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the apache package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
if ( ! pkgs ) exit(0);

package = egrep(pattern:"^apache-2", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"apache-2.0.51") < 0 ) 
	security_warning(0);
