#
# (C) Tenable Network Security
#
# The plugin description is (C) Jacques Vidrine and contributors. 
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(15795);
 script_version ("$Revision: 1.1 $");
 script_cve_id ("CAN-2004-0981");
 name["english"] = "FreeBSD Ports : ImageMagick < 6.1.3";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has one of the following packages installed :

ImageMagick < 6.1.3

There exist a buffer overflow vulnerability in  ImageMagick's EXIF parsing 
code which may lead to execution of arbitrary code

Solution : http://www.vuxml.org/freebsd/eeb1c128-33e7-11d9-a9e7-0001020eed82.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the apache package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^ImageMagick-[0-6]\.", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"ImageMagick-6.1.3") < 0  )
	{
	security_hole(0);
	exit(0);
	}
