### Name: bxp
### Title: Box Plots from Summaries
### Aliases: bxp
### Keywords: aplot

### ** Examples

set.seed(753)
(bx.p <- boxplot(split(rt(100, 4), gl(5,20))))
op <- par(mfrow= c(2,2))
bxp(bx.p, xaxt = "n")
bxp(bx.p, notch = TRUE, axes = FALSE, pch = 4, col=1:5)
bxp(bx.p, notch = TRUE, col= "lightblue", frame= FALSE, outl= FALSE,
    main = "bxp(*, frame= FALSE, outl= FALSE)")
bxp(bx.p, notch = TRUE, col= "lightblue", border= 2:6, ylim = c(-4,4),
    pch = 22, bg = "green", log = "x", main = "... log='x', ylim=*")
par(op)
op <- par(mfrow= c(1,2))
data(PlantGrowth)
## single group -- no label
boxplot (weight~group, data=PlantGrowth, subset=group=="ctrl")
## with label
bx<-boxplot(weight~group, data=PlantGrowth, subset=group=="ctrl",plot=FALSE)
bxp(bx,show.names=TRUE)
par(op)



