### Name: jack.after.boot
### Title: Jackknife-after-Bootstrap Plots
### Aliases: jack.after.boot
### Keywords: hplot nonparametric

### ** Examples

#  To draw the jackknife-after-bootstrap plot for the head size data as in
#  Example 3.24 of Davison and Hinkley (1997)
pcorr <- function( x )
{ 
#  function to find the correlations and partial correlations between
#  the four measurements.
     v <- cor(x)
     v.d <- diag(var(x))
     iv <- solve(v)
     iv.d <- sqrt(diag(iv))
     iv <- - diag(1/iv.d) %*% iv %*% diag(1/iv.d)
     q <- NULL
     n <- nrow(v)
     for (i in 1:(n-1)) 
          q <- rbind( q, c(v[i,1:i],iv[i,(i+1):n]) )
     q <- rbind( q, v[n,] )
     diag(q) <- round(diag(q))
     q
}

frets.fun <- function( data, i )
{    d <- data[i,]
     v <- pcorr( d )
     c(v[1,],v[2,],v[3,],v[4,])
}
data(frets)
frets.boot <- boot(log(as.matrix(frets)), frets.fun, R=999)
#  we will concentrate on the partial correlation between head breadth
#  for the first son and head length for the second.  This is the 7th
#  element in the output of frets.fun so we set index=7
jack.after.boot(frets.boot,useJ=FALSE,stinf=FALSE,index=7)



