### Name: library
### Title: Loading and Listing of Packages
### Aliases: library require R_LIBS .Autoloaded .First.lib .Last.lib
###   .Library .find.package .packages .path.package .libPaths .noGenerics
###   print.libraryIQR print.packageInfo
### Keywords: data

### ** Examples

(.packages())               # maybe just "base"
.packages(all = TRUE)       # return all available as character vector
library()                   # list all available packages
library(lib = .Library)     # list all packages in the default library
library(help = eda)         # documentation on package 'eda'
library(eda)                # load package 'eda'
require(eda)                # the same
(.packages())               # "eda", too
detach("package:eda")

# if the package name is in a character vector, use
pkg <- "eda"
library(pkg, character.only = TRUE)
detach(pos = match(paste("package", pkg, sep=":"), search()))

require(pkg, character.only = TRUE)
detach(pos = match(paste("package", pkg, sep=":"), search()))

.path.package()
.Autoloaded                 # maybe "ctest"

.libPaths()                 # all library trees R knows about

require(nonexistent)        # FALSE
## Not run: 
##D ## Suppose a package needs to call a shared library named 'fooEXT',
##D ## where 'EXT' is the system-specific extension.  Then you should use
##D .First.lib <- function(lib, pkg) {
##D   library.dynam("foo", pkg, lib)
##D }
##D 
##D ## if you want to mask as little as possible, use
##D library(mypkg, pos = "package:base")
## End(Not run)


