#
# (C) Tenable Network Security
#


head = "
The remote version of Windows contains a version of the Java JRE
which is older than 1.4.2_06 / 1.3.1_13. 

Even if a newer version of this software is installed, a malicious Java
Applet may invoke a particular version of the Java JRE to be executed with.

As a result, a rogue java applet may exploit this vulnerability to request
to be executed with a known to be buggy version of the Java JRE.";


tail = "

Solution : De-install older versions of the Java JRE
Risk factor: High";

if(description)
{
 script_id(15926);
 script_bugtraq_id(11757);
 script_version("$Revision: 1.1 $");

 name["english"] = " Sun Java Applet Invocation Version Specification";
 script_name(english:name["english"]);


 script_description(english:head + tail);
 summary["english"] = "Checks for older versions of the Java SDK and JRE";
 script_summary(english:summary["english"]);
 script_category(ACT_GATHER_INFO);
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"]= "Windows";
 script_family(english:family["english"]);
 script_dependencies("smb_registry_full_access.nasl", "smb_hotfixes.nasl");
 script_require_keys("SMB/registry_full_access");
 script_require_ports(139, 445);
 exit(0);
}

# start script

include("smb_nt.inc");

port = get_kb_item("SMB/transport");
if(!port) port = 445;
#access = get_kb_item("SMB/registry_full_access");
#if(!access) exit(0);

x_name = kb_smb_name();
if(!x_name)exit(0);

_smb_port = kb_smb_transport();
if(!_smb_port)exit(0);

if(!get_port_state(_smb_port)) exit(0);
login = kb_smb_login();
pass  = kb_smb_password();
domain = kb_smb_domain();

if(!login)login = "";
if(!pass) pass = "";

          
soc = open_sock_tcp(_smb_port);
if(!soc) exit(0);

#
# Request the session
# 
r = smb_session_request(soc:soc,  remote:x_name);

if(!r) { close(soc); exit(0); }

#
# Negociate the protocol
#
prot = smb_neg_prot(soc:soc);
if(!prot){ close(soc); exit(0); }


r = smb_session_setup(soc:soc, login:login, password:pass, domain:domain, prot:prot);
if(!r){ close(soc); exit(0); }
uid = session_extract_uid(reply:r);

r = smb_tconx(soc:soc, name:x_name, uid:uid, share:"IPC$");
tid = tconx_extract_tid(reply:r);
if(!tid){ close(soc); exit(0); }


r = smbntcreatex(soc:soc, uid:uid, tid:tid, name:"\winreg");
if(!r){ close(soc); exit(0);}
pipe = smbntcreatex_extract_pipe(reply:r);



r = pipe_accessible_registry(soc:soc, uid:uid, tid:tid, pipe:pipe);
if(!r){ close(soc); exit(0); }
handle = registry_open_hklm(soc:soc, uid:uid, tid:tid, pipe:pipe);
key = "SOFTWARE\JavaSoft\Java Runtime Environment";

key_h = registry_get_key(soc:soc, uid:uid, tid:tid, pipe:pipe, key:key, reply:handle);
if ( key_h )
{
 # Is the remote machine using the JRE?
 item= "CurrentVersion";
 data = registry_get_item_sz(soc:soc, uid:uid, tid:tid, pipe:pipe, item:item, reply:key_h);
 value = registry_decode_sz(data:data);
 if ( ! value ) exit(0);
}


entries = registry_enum_key(soc:soc, uid:uid, tid:tid, pipe:pipe, reply:key_h);
report = head + '\nThe remote host has the following versions installed : \n';
foreach entry (entries)
{
 report += '\n - ' + entry;
}

report += tail;

foreach entry (entries)
{
 if ( ereg(pattern:"^(0\.|1\.[0-2]\.|1\.3\.0|1\.3\.1_([0-9]$|1[0-2]$)|1\.4\.([01]|2_0[0-5]))", string:entry) ) 
	{
	 security_hole ( port:port, data:report );
	 exit(0);
	}
}
