#TRUSTED 045905d398e8926997b36f60d2f2c5a808a8c6b6ae9b62f67caae7ceec8466252a1df08d9a3e94f273c78be87f1f676e5f2e7c61b5bc1015b78d64ff9f3d6fb2a7aa4661aac5b5f5eb7d2a6438fecc7642d1d5e130914a22240cab1ed3a62e8abf438ef663a8d7f51a581a5e36d076738c31c03a66e569e58183272c52630a64ba07151db76b3fbb2f567b1aa940ef9b56330d624010389c28bf48a8ba807b52c08a354b5f510aeffd669b3f656a6d03ef56482f4e85fd93fd5e7dad334404edb650a74cf4f1d454c27bffda5f7da566879897734f0bb3028a0ae8f26dc3c8f3aa55d04de4d3ab2b6d6e596b46d5d167bd8e396a7bf0869effa3932c3ecf3d9d349f0a71ba339e19bc77a7edc8ed7e7e8deded1cabc3b23f5d69a60a3d40b76a87a9dd67b20ed810aa6e03a7ef41be6e5fd423256149dfe4ae6939fb4a7b5cd77f51f92f6df61ccdddd89bc8878f11b5208b516079a71bbf0d6c4675911ea347339df0dc1585784eb5fe5b37404573f399787baf61f3fec40f98e95ca26e021994412d7740cd29b2426c933429ab88773a5e2ce829e26554d3ae31eea6bd3441a9216bf0a8bf763cbc30ea69aefe85299b954b9402545d4d5aac2f0366bc94777eb6724785c4b72292dd9c1514d8341eff147eeb81284b2391f9609770addd1645fba40bf264798a9723bed723b45f01fff7021c418b2340613ddb9112140fbe
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra")) exit(0);


if(description)
{
 script_id(15872);
 script_version ("1.1");
 name["english"] = "Hydra: FTP";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find FTP accounts & passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force FTP authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/logins_file", "Secret/hydra/passwords_file");
 script_require_ports("Services/ftp", 21);
 script_dependencies("hydra_options.nasl", "find_service.nes", "doublecheck_std_services.nasl", "find_service_3digits.nasl");
 exit(0);
}

#
throrough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< throrough) exit(0);
logins = get_kb_item("Secret/hydra/logins_file");
passwd = get_kb_item("Secret/hydra/passwords_file");
if (logins == NULL || passwd == NULL) exit(0);

port = get_kb_item("Services/ftp");
if (! port) port = 21;
if (! get_port_state(port)) exit(0);

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
login_pass = get_kb_item("/tmp/hydra/login_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-p"; argv[i++] = port;
argv[i++] = "-L"; argv[i++] = logins;
argv[i++] = "-P"; argv[i++] = passwd;
s = "";
if (empty) s = "n";
if (login_pass) s+= "s";
if (s)
{
  argv[i++] = "-e"; argv[i++] = s;
}
if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-w";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "ftp";

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*login: *(.*) password: *(.*)$');
  if (! isnull(v))
  {
    l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, 'username: ', l, '\tpassword:', p, '\n');
    set_kb_item(name: 'Hydra/ftp/'+port, value: l + '\t' + p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following FTP accounts:\n' + report);
