#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12620);
 script_cve_id("CAN-2004-0411");
 script_version ("$Revision: 1.2 $");
 name["english"] = "FreeBSD Ports : URI vulnerability in several browser";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has one of the following package version installed :

 linux-opera < 7.50
 opera < 7.50
 kdelibs < 3.2.2_3

There is a flaw in the URI handler of these softwares which may allow an 
attacker to execute arbitrary commands on the remote host by sending
a malformed URI to a victim on this host.

Solution : http://www.vuxml.org/freebsd/df333ede-a8ce-11d8-9c6d-0020ed76ef5a.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of several packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^linux-opera", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"linux-opera-7.50") < 0 )
	{
	security_hole(0);
	exit(0);
	}

package = egrep(pattern:"^opera", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"opera-7.50") < 0 )
	{
	security_hole(0);
	exit(0);
	}

package = egrep(pattern:"^kdelibs", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"kdelibs-3.2.2_3") < 0 )
	security_hole(0);
