#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(15508);
 script_bugtraq_id(11312);
 script_version ("$Revision: 1.1 $");
 name["english"] = "FreeBSD Ports : tor < 0.0.8.1";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has the following package installed :
	tor < 0.0.8.1

tor is an anonymizing network overlay for TCP connections.

The remote version of this software is vulnerable to several denial of
service attacks which can be used to defeat the client's anonymity.

Solution : http://www.vuxml.org/freebsd/8e2e6ad8-1720-11d9-9fb9-00902788733b.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the tor package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
if ( ! pkgs ) exit(0);

package = egrep(pattern:"^tor-0\.", string:pkgs);
if (package && pkg_cmp(pkg:package, reference:"tor-0.0.8.1") < 0 )
	security_warning(0);
