#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12619);
 script_bugtraq_id(9263, 9423);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2003-0989", "CAN-2003-1029", "CAN-2004-0057");
 name["english"] = "FreeBSD : tcpdump < 3.8.1_351 or FreeBSD < 5.2.1";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of tcpdump installed.

tcpdump is a network sniffer. There is a bug in the remote version of this
software when it processes the L2TP, ISAKMP and the RADIUS protocols, which
in turn may be used by an attacker to crash the tcpdump process.

Solution : http://www.vuxml.org/freebsd/96ba2dae-4ab0-11d8-96f2-0020ed76ef5a.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the tcpdump package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^tcpdump", string:pkgs);
if ( package )
{
if ( pkg_cmp(pkg:package, reference:"tcpdump-3.8.1_351") < 0 ) 
	{
	security_warning(0);
	exit(0);
	}
}


package = get_kb_item("Host/FreeBSD/release");
if ( egrep(pattern:"FreeBSD-5\.2", string:package) )
{
 if ( pkg_cmp(pkg:package, reference:"FreeBSD-5.2.1") < 0 )
 {
  security_warning(port);
  exit(0);
 }
}
