#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(14844);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CAN-2004-0749");
 name["english"] = "FreeBSD Ports : subversion < 1.0.8";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has a version of the subversion package which is older 
than 1.0.8.

subversion is a source versionning system, akin to cvs. There is a bug in the
remote version of this package which may allow an attacker to disclose 
metadata using WebDAV.

An attacker may exploit this flaw to gain access to information regarding
files he should not have access to.

Solution : http://www.vuxml.org/freebsd/184f5d0b-0fe8-11d9-8a8a-000c41e2cdad.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the subversion package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");

pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^subversion-", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"subversion-1.0.8") < 0 ) 
        {
        security_warning(0);
        exit(0);
        }
