#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(14383);
 script_bugtraq_id(10819);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CAN-2004-0557");
 name["english"] = "FreeBSD Ports : sox < 12.17.1";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the Sox package installed.

SoX (Sound eXchange) is a sound file format converter SoX can convert
between many different digitized sound formats and perform simple
sound manipulation functions, including sound effects.

There are several buffer overflows in the WAV file handling code of the remote
version of this software. To exploit this flaw, an attacker would need to
send a malformed wav file to a user on the remote host and wait for him
to process it using SoX.

Solution : http://www.vuxml.org/freebsd/3e4ffe76-e0d4-11d8-9b0a-000347a4fa7d.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the sox package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");

pkgs = get_kb_item("Host/FreeBSD/pkg_info");
if ( ! pkgs ) exit(0);

package = egrep(pattern:"^sox-12\.", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"sox-12.17.1") > 0 &&
                pkg_cmp(pkg:package, reference:"sox-12.17.4_1") <= 0 ) 
        {
        security_hole(0);
        exit(0);
        }
