#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12591);
 script_bugtraq_id(10633);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2004-0456");
 if ( defined_func("script_xref") ) script_xref(name:"OSVDB", value:"7319");


 name["english"] = "FreeBSD Ports : Pavuk < 0.9.28_5";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the package pavuk installed (older than
version 0.9.28_5).

Pavuk is a FTP, WWW and Gopher mirroring tool. There remote version of this
software contains a buffer overflow in the HTTP module, which may allow an attacker
to execute arbitrary code on the remote host.

To exploit this flaw, an attacker would need to set up a rogue HTTP server
and lure a victim of the remote host into mirroring it using Pavuk. He would
then be able to send a malformed 305 response code which would overflow a 
buffer in the pavuk utility.

Solution : http://www.vuxml.org/freebsd/76904dce-ccf3-11d8-babb-000854d03344.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the pavuk package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
package = egrep(pattern:"^pavuk-", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"pavuk-0.9.28_5") < 0 ) 
	security_hole(0);
