#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(14846);
 script_version ("$Revision: 1.1 $");
 name["english"] = "FreeBSD Ports : MySQL-client <= 4.1.4";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the mysql-client package
installed.

There is a buffer overflow in the prepared statement API (libmysqlclient) which
may allow an attacker to execute arbitrary code on this host. To exploit this
flaw an attacker would required access to a mysql database using a tool using
libmysqlclient.

See also : http://bugs.mysql.com/bug.php?id=5194
Solution : http://www.vuxml.org/freebsd/77420ebb-0cf4-11d9-8a8a-000c41e2cdad.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the mysql-client package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");

pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^mysql-client-4\.1", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"mysql-client-4.1.4") <= 0 ) 
        {
        security_hole(0);
        exit(0);
        }
