#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(14721);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CAN-2004-0805");
 name["english"] = "FreeBSD Ports : mpg123 < 0.59r_14";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the mpg123 package installed.

mpg123 is a command-line player for mpeg layer 1, 2 and 3 audio files.
There are is a vulnerability in this version of the software which may
allow an attacker to execute arbitrary code on this host.

To exploit these vulnerabilities, an attacker would need to craft a malformed
mp3 file and have a user of the remote host read it using mpg123.

Solution : http://www.vuxml.org/freebsd/15e0e963-02ed-11d9-a209-00061bc2ad93.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the mpg123 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
if ( ! pkgs ) exit(0);

package = egrep(pattern:"^mpg123-0", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"mpg123-0.59r_14") < 0 ) 
	security_hole(0);
