#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(14757);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CAN-2004-0722");
 name["english"] = "FreeBSD Ports : Mozilla < 1.7.2 or Firbird < 0.9";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the mozilla, linux-mozilla, mozilla-gtk1,
or firebird package installed.

These packages include a web browser which is vulnerable to an integer
overflow in the SOAPParameter component.

To exploit this flaw, an attacker would need to set up a rogue website and
lure a user of the remote host to visit it using one of the affected
packages.

Solution : http://www.vuxml.org/freebsd/a4fd8f53-05eb-11d9-b45d-000c41e2cdad.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the mozilla packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
if ( ! pkgs ) exit(0);

package = egrep(pattern:"^mozilla-1", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"mozilla-1.7,2") < 0 ) 
	{
	security_hole(0);
	exit(0);
	}
package = egrep(pattern:"^mozilla-gtk1-", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"mozilla-gtk1-1.7") < 0 ) 
	{
	security_hole(0);
	exit(0);
	}
package = egrep(pattern:"^linux-mozilla-", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"linux-mozilla-1.7") < 0 ) 
	{
	security_hole(0);
	exit(0);
	}
package = egrep(pattern:"^linux-mozilla-devel", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"linux-mozilla-devel-1.7") < 0 ) 
	{
	security_hole(0);
	exit(0);
	}
package = egrep(pattern:"^netscape7-", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"netscape7-7.2") < 0 ) 
	{
	security_hole(0);
	exit(0);
	}
package = egrep(pattern:"^firebird-", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"firebird-0.9") < 0 ) 
	{
	security_hole(0);
	exit(0);
	}
