#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12554);
 script_version ("$Revision: 1.2 $");
 name["english"] = "FreeBSD Ports : INN < 2.4.1";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an installed version of the INN package which is older
than 2.4.1.

INN stands for 'Internet News Server' and is typically in charge of
distributing usenet news.

There is a stack overflow in the remote version of INN which might allow
an attacker to execute arbitrary code on the remote host.

Solution : http://www.vuxml.org/freebsd/fd376b8b-41e1-11d8-b096-0020ed76ef5a.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the inn package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^inn-[0-9]*", string:pkgs);

if ( package )
{
if ( pkg_cmp(pkg:package, reference:"inn-2.4.1") < 0 ) 
	security_hole(0);
}

package = egrep(pattern:"^inn-stable", string:pkgs);

if ( package )
{
if ( pkg_cmp(pkg:package, reference:"inn-stable-20031022_1") < 0 ) 
	security_hole(0);
}
