#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(15502);
 script_version ("$Revision: 1.1 $");
 name["english"] = "FreeBSD Ports : icecast2 < 2.0.2,1";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has the following package installed :
	icecast < 2.0.2,1


Icecast is a streaming mp3 audio server. 

The remote version of this software is vulnerable to a buffer overflow condition
which may allow a remote attacker to execute arbitrary code on the remote
host.

Solution : http://www.vuxml.org/freebsd/741c3957-1d69-11d9-a804-0050fc56d258.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the icecast2 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
if ( ! pkgs ) exit(0);

package = egrep(pattern:"^icecast2-2", string:pkgs);
if (package && pkg_cmp(pkg:package, reference:"icecast2-2.0.2,1") < 0 )
	security_hole(0);
