#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(15799);
 script_version ("$Revision: 1.1 $");
 script_cve_id ( "CAN-2004-1007" );
 name["english"] = "FreeBSD Ports : 0.17.4 <= bogofilter < 0.92.8";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has one of the following packages installed :
0.17.4 <= bogofilter < 0.92.8
0.17.4 <= bogofilter-qdbm < 0.92.8
0.17.4 <= bogofilter-tdb < 0.92.8
0.17.4 <= ru-bogofilter < 0.92.8

The bogofilter team has been provided with a test case of a  malformatted 
(non-conformant) RFC-2047 encoded word that can cause  bogofilter versions 
0.92.7 and prior to try to write a NUL byte into  a memory location that is 
either one byte past the end of a flex  buffer or to a location that is the 
negative of the encoded word's  start of payload data, causing a segmentation 
fault.

Solution : http://www.vuxml.org/freebsd/f4428842-a583-4a4c-89b7-297c3459a1c3.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the bogofilter package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^bogofilter-0\.", string:pkgs);
if ( package && 
  	pkg_cmp(pkg:package, reference:"bogofilter-0.92.8") <= 0 &&
        pkg_cmp(pkg:package, reference:"bogofilter-0.17.4") >= 0 ) 
	{
	security_warning(0);
	exit(0);
	}
package = egrep(pattern:"^bogofilter-qdbm-0\.", string:pkgs);
if ( package && 
  	pkg_cmp(pkg:package, reference:"bogofilter-qdbm-0.92.8") <= 0 &&
        pkg_cmp(pkg:package, reference:"bogofilter-qdbm-0.17.4") >= 0 ) 
	{
	security_warning(0);
	exit(0);
	}
package = egrep(pattern:"^bogofilter-tdb-0\.", string:pkgs);
if ( package && 
  	pkg_cmp(pkg:package, reference:"bogofilter-tdb-0.92.8") <= 0 &&
        pkg_cmp(pkg:package, reference:"bogofilter-tdb-0.17.4") >= 0 ) 
	{
	security_warning(0);
	exit(0);
	}
package = egrep(pattern:"^ru-bogofilter-0\.", string:pkgs);
if ( package && 
  	pkg_cmp(pkg:package, reference:"ru-bogofilter-0.92.8") <= 0 &&
        pkg_cmp(pkg:package, reference:"ru-bogofilter-0.17.4") >= 0 ) 
	{
	security_warning(0);
	exit(0);
	}
