#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12523);
 script_bugtraq_id(9772);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2004-0353", "CAN-2004-0354");
 name["english"] = "FreeBSD Ports : anubis <= 3.6.2_1";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an installed version of the anubis package which is
older than 3.6.2_2.

Anubis is an outgoing SMTP mail processor. There are several vulnerabilities
in the remote version of this package which may allow an attacker to execute
arbitrary code on this host. To exploit these vulnerabilities, an attacker
would need to set upa  rogue IDENT server which would need to be contacted
by anubis.

Solution : http://www.vuxml.org/freebsd/8471bb85-6fb0-11d8-873f-0020ed76ef5a.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the anubis package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
if ( ! pkgs ) exit(0);

package = egrep(pattern:"^anubis-", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"anubis-3.6.2_2") < 0 ) 
	security_hole(0);
