/********************************************************************************
*                                                                               *
*                        G I F   C u r so r   O b j e c t                       *
*                                                                               *
*********************************************************************************
* Copyright (C) 2000,2003 by Daniel Gehriger.   All Rights Reserved.            *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************
* $Id: FXGIFCursor.h,v 1.14 2003/06/19 16:35:10 fox Exp $                       *
********************************************************************************/
#ifndef FXGIFCURSOR_H
#define FXGIFCURSOR_H

#ifndef FXCURSOR_H
#include "FXCursor.h"
#endif

namespace FX {

//////////// WE PROBABLY WANT SOME OPTIONS HERE SAME AS FXGIFIcon ///////////////

/// GIF Cursor class
class FXAPI FXGIFCursor : public FXCursor {
  FXDECLARE(FXGIFCursor)
protected:
  FXGIFCursor(){}
private:
  FXGIFCursor(const FXGIFCursor&);
  FXGIFCursor &operator=(const FXGIFCursor&);
public:

  /// Construct a cursor from memory stream formatted as CompuServe GIF format
  FXGIFCursor(FXApp* a,const void* pix,FXint hx=0,FXint hy=0);

  /// Destroy
  virtual ~FXGIFCursor(){}
  };


/**
* Load an GIF (Graphics Interchange Format) file from a stream.
* Upon successful return, the pixel array and size are returned.
* If an error occurred, the pixel array is set to NULL.
*/
extern FXAPI FXbool fxloadGIF(FXStream& store,FXColor*& data,FXint& width,FXint& height);


/**
* Save an GIF (Graphics Interchange Format) file to a stream.
*/
extern FXAPI FXbool fxsaveGIF(FXStream& store,const FXColor *data,FXint width,FXint height);

}

#endif
