/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.internal.operation;

import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.uml2.ElementImport;
import org.eclipse.uml2.PackageableElement;
import org.eclipse.uml2.UML2Plugin;
import org.eclipse.uml2.VisibilityKind;
import org.eclipse.uml2.internal.operation.UML2Operations;

public final class ElementImportOperations
extends UML2Operations {
    private ElementImportOperations() {
    }

    public static String getName(ElementImport elementImport) {
        return UML2Operations.isEmpty(elementImport.getAlias()) ? (elementImport.getImportedElement() == null ? "" : elementImport.getImportedElement().getName()) : elementImport.getAlias();
    }

    public static boolean validateVisibilityPublicOrPrivate(ElementImport elementImport, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        if (!((Object)((Object)VisibilityKind.PUBLIC_LITERAL)).equals((Object)elementImport.getVisibility()) && !((Object)((Object)VisibilityKind.PRIVATE_LITERAL)).equals((Object)elementImport.getVisibility())) {
            result = false;
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2", 32, UML2Plugin.INSTANCE.getString("_UI_ElementImport_VisibilityPublicOrPrivate_diagnostic", UML2Operations.getMessageSubstitutions(context, elementImport)), new Object[]{elementImport}));
            }
        }
        return result;
    }

    public static boolean validateImportedElementIsPublic(ElementImport elementImport, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        PackageableElement importedElement = elementImport.getImportedElement();
        if (importedElement != null && importedElement.getVisibility() != null && !((Object)((Object)VisibilityKind.PUBLIC_LITERAL)).equals((Object)importedElement.getVisibility())) {
            result = false;
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2", 33, UML2Plugin.INSTANCE.getString("_UI_ElementImport_ImportedElementIsPublic_diagnostic", UML2Operations.getMessageSubstitutions(context, importedElement)), new Object[]{elementImport, importedElement}));
            }
        }
        return result;
    }
}

