/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.examples.ui.wizards;

import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.ui.dialogs.FileSystemElement;
import org.eclipse.ui.dialogs.WizardResourceImportPage;
import org.eclipse.ui.model.WorkbenchContentProvider;

public abstract class ExampleWizardResourceImportPage
extends WizardResourceImportPage {
    protected static FileSystemElement createFileSystemElement(FileSystemElement parent, IResource resource, String extension) {
        FileSystemElement result = null;
        String label = resource.getName();
        switch (resource.getType()) {
            case 1: {
                if (!resource.getName().endsWith(String.valueOf('.') + extension)) break;
                result = new FileSystemElement(label, parent, false);
                result.setFileSystemObject((Object)resource);
                break;
            }
            case 8: {
                label = "workspace";
            }
            default: {
                result = new FileSystemElement(label, parent, true);
                result.setFileSystemObject((Object)resource);
                try {
                    IResource[] members = ((IContainer)resource).members();
                    int index = 0;
                    while (index < members.length) {
                        ExampleWizardResourceImportPage.createFileSystemElement(result, members[index], extension);
                        ++index;
                    }
                }
                catch (CoreException coreException) {}
                if (result.getFolders().size() != 0 || result.getFiles().size() != 0 || parent == null) break;
                parent.removeFolder(result);
                result = null;
            }
        }
        return result;
    }

    protected ExampleWizardResourceImportPage(String name, IStructuredSelection selection) {
        super(name, selection);
    }

    protected ITreeContentProvider getFileProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object element) {
                if (element instanceof FileSystemElement) {
                    return ((FileSystemElement)element).getFiles().getChildren(element);
                }
                return new Object[0];
            }
        };
    }

    protected ITreeContentProvider getFolderProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object element) {
                if (element instanceof FileSystemElement) {
                    return ((FileSystemElement)element).getFolders().getChildren(element);
                }
                return new Object[0];
            }
        };
    }

    public List getSelectedResources() {
        return super.getSelectedResources();
    }

    public IContainer getSpecifiedContainer() {
        return super.getSpecifiedContainer();
    }
}

