\name{lookup.xport}
\alias{lookup.xport}
\title{Lookup information on a SAS XPORT format library}
\description{
  Scans a file as a SAS XPORT format library and returns a list
  containing information about the SAS library.
}
\usage{
lookup.xport(file)
}
\arguments{
  \item{file}{character variable with the name of the file to read.  The
    file must be in SAS XPORT format.}
}
\value{
  A list with one component for each dataset in the XPORT format library.
}
\references{
  SAS Technical Support document TS-140:
  ``The Record Layout of a Data Set in SAS Transport (XPORT) Format''
  available as
  \url{http://ftp.sas.com/techsup/download/technote/ts140.html}.
} 
\author{Saikat DebRoy}
\seealso{
  \code{\link{read.xport}}
}
\examples{
\dontrun{
lookup.xport("transport")
}
}
\keyword{file}

\eof
\name{S3 read functions}
\alias{data.restore}
\alias{read.S}
% \alias{SModeNames}
\title{Read an S3 Binary File}
\description{
  Reads binary data files or \code{data.dump} files that were produced
  in S version 3.
}
\usage{
  data.restore(file, print = FALSE, verbose = FALSE, env = .GlobalEnv)
  read.S(file)
}
\arguments{
  \item{file}{the filename of the S-PLUS \code{data.dump} or binary
    file.}
  \item{print}{whether to print the name of each object as read from the
    file.}
  \item{verbose}{whether to print the name of every subitem within each
    object.}
  \item{env}{environment within which to create the restored object.}
}
\value{
  an R version of the S3 object.
}
\details{
  \code{read.S} can read the binary files produced in most recent
  versions of S-PLUS on either Windows (versions 3.x, 4.x, 2000) or Unix
  (version 3.x with 4 byte integers). It automatically detects whether
  the file was produced on a big- or little-endian machine and adapts
  itself accordingly.  \code{data.restore} can read a similar range of
  files produced by \code{data.dump}.

  Not all S3 objects can be handled in the current version.  The most
  frequently encountered exceptions are functions and expressions; you
  will also have trouble with objects that contain model formulas.  In 
  particular, comments will be lost from function bodies, and the 
  argument lists of functions will often be changed.

%  The \code{SModeNames} variable contains a list of the modes of
%  variables as used in S3.
}
\author{
  Duncan Murdoch
}
\examples{
\dontrun{read.S(file.path("_Data", "myobj"))
data.restore("dumpdata", print = TRUE)
}}
\keyword{data}
\keyword{file}

\eof
\name{read.dta}
\alias{read.dta}
\title{Read Stata binary files}
\description{
  Reads a file in Stata version 5-8 or 7/SE binary format into a data frame. 
}
\usage{
read.dta(file, convert.dates = TRUE, tz = "GMT",
         convert.factors = TRUE, missing.type = FALSE,
         convert.underscore=TRUE)
}
\arguments{
  \item{file}{a filename as a character string.}
  \item{convert.dates}{Convert Stata dates to \code{POSIXct} class?}
  \item{tz}{timezone for date conversion}
  \item{convert.factors}{Use Stata value labels to create factors?
    (version 6.0 or later)}
  \item{missing.type}{For version 8 only, store information about
    different types of missing data?}
  \item{convert.underscore}{Convert \code{"_"} in Stata variable names
    to \code{"."} in R names?}
}
\details{
  The variables in the Stata data set become the columns of the data
  frame.  Missing values are correctly handled.  The data label,
  variable labels, and timestamp are stored as attributes of the data
  frame.  Nothing is done with variable characteristics.

  Optionally, Stata dates (\%d formats) are converted to \R's
  \code{POSIXct} class and variables with Stata value labels are
  converted to factors. In any case the value label and format
  information is stored as attributes on the returned data frame. 

  Stata 8.0 has 27 different missing data values. If \code{missing.type}
  is \code{TRUE} a separate list is created with the same variable
  names as the loaded data. For string variables the list value is
  \code{NULL}. For other variables the value is \code{NA} where the
  observation is not missing and 0-26 when the observation is
  missing. This is attached as the code{"missing"} attribute of the
  returned value.
  
  The option to allow underscores in variable names may become the
  default in future versions now that R supports their use.
}
\value{
  a data frame
}
\references{
  Stata Users Manual (versions 5 & 6), Programming manual (version 7),
  or online help (version 8) describe the format of the files
}

\author{Thomas Lumley}
\seealso{
  \code{\link{write.dta}},
  \code{\link{attributes}}
  \code{\link{DateTimeClasses}}
  \code{\link{factor}}
}
\examples{
data(swiss)
write.dta(swiss,swissfile<-tempfile())
read.dta(swissfile)
}
\keyword{file}

\eof
\name{read.epiinfo}
\alias{read.epiinfo}
\title{Read Epi Info data files}
\description{
  Reads data files in the \code{.REC} format used by Epi Info versions 6
  and earlier and by EpiData. Epi Info is a public domain database and
  statistics  package  produced by the US Centers for Disease Control
  and EpiData is a freely available data entry and validation system.
  }
\usage{
read.epiinfo(file, read.deleted=FALSE, guess.broken.dates=FALSE,
             thisyear=NULL, lower.case.names = FALSE)
}
\arguments{
  \item{file}{A filename, URL, or connnection }
  \item{read.deleted}{Deleted records are read if \code{TRUE}, omitted
    if \code{FALSE} or replaced with \code{NA} if \code{NA} }
  \item{guess.broken.dates}{Attempt to convert dates with 0 or 2 digit
    year information (see Details below)}
  \item{thisyear}{A 4-digit year to use for dates with no year. Defaults
    to the current year}
  \item{lower.case.names}{Convert variable names to lowercase?}
}
\details{
  Epi Info allows dates to be specified with no year or with a 2 or 4
  digits.  Dates with four-digit years are always converted to
  \code{POSIXct}. With the \code{guess.broken.dates} option the function
  will attempt to convert two-digit years using the operating system's
  default method (see \link{DateTimeClasses}) and will use the current
  year or the \code{thisyear} argument for dates with no year
  information.

  If \code{read.deleted} is \code{TRUE} the \code{"deleted"} attribute
  of the data frame indicates the deleted records.
}
\note{  Epi Info 2000, the current version, uses the Microsoft Access file
  format to store data. This may be readable with the \code{RODBC} or
  \code{RDCOM} packages.
}
\value{
  A data frame.
}
\references{
  \url{http://www.cdc.gov/epiinfo/},
  \url{http://www.epidata.dk}
}

\seealso{\link{DateTimeClasses} }

\examples{
\dontrun{
data<-read.epiinfo("oswego.rec",guess.broken.dates=TRUE,thisyear="1972")
}
}
\keyword{ file }

\eof
\name{read.mtp}
\alias{read.mtp}
\title{Read a Minitab Portable Worksheet}
\description{
  Return a list with the data stored in a file as a Minitab Portable
  Worksheet.
}
\usage{
read.mtp(file)
}
\arguments{
  \item{file}{character variable with the name of the file to read.  The
    file must be in Minitab Portable Worksheet format.}
}
\value{
  A list with one component for each column, matrix, or constant stored
  in the Minitab worksheet.
}
\references{
  \url{http://www.minitab.com/}
}
\author{Douglas M. Bates}
\examples{
\dontrun{
read.mtp("ex1-10.mtp")
}
}
\keyword{file}

\eof
\name{read.spss}
\alias{read.spss}
\title{Read an SPSS data file}
\description{
  \code{read.spss} reads a file stored by the SPSS \code{save} and
  \code{export} commands and returns a list.
}
\usage{
read.spss(file, use.value.labels=TRUE, to.data.frame=FALSE,
          max.value.labels=Inf)
}
\arguments{
  \item{file}{ character variable with the name of the file to read.}
  \item{use.value.labels}{ Convert variables with value labels into \R
    factors with those levels?}
  \item{to.data.frame}{return a data frame?}
  \item{max.value.labels}{Only variables with at most this many unique
    values will be converted to factors}
}
\value{
  A list (or data frame) with one component for each variable in the saved data set.
}
\details{
  This uses modified code from the PSPP project for reading the SPSS
  formats.

  Occasionally in SPSS value labels will be added to some values of a
  continuous variable (eg to distinguish different types of missing
  data), and you will not want these variables converted to factors.
  By setting \code{max.val.labels} you can specify that variables
  with a large number of distinct values are not converted to factors
  even if they have value labels. The value labels are then returned in
  the \code{"value.labels"} attribute of the variable.
  
  If SPSS variable labels are present, they are returned as the
  \code{"variable.labels"} attribute of the answer.

  Fixed length strings (including value labels) are padded on the right
  with spaces by SPSS, and so are read that way by R.  See the examples
  for \code{\link{sub}} for ways to remove trailing spaces.
}
\author{Saikat DebRoy}
\examples{
\dontrun{
read.spss("datafile")
## don't convert value labels to factor levels
read.spss("datafile",use.value.labels=FALSE)
## convert value labels to factors for variables with at most
## ten distinct values.
read.spss("datafile",max.val.labels=10)
}
}
\keyword{file}

\eof
\name{read.ssd}
\alias{read.ssd}
\title{ obtain a data frame from a SAS permanent dataset, via read.xport }
\description{
  generates a SAS program to convert the ssd contents to SAS transport format
  and then uses \code{read.xport} to obtain a dataframe
}
\usage{
read.ssd(libname, sectionnames, 
   tmpXport=tempfile(), tmpProgLoc=tempfile(), sascmd="sas")
}
\arguments{
  \item{libname}{ string defining the SAS library (usually a directory reference)}
  \item{sectionnames}{ vector of strings giving member names. These are
files in the `libname' directory. They will usually have a `.ssd0x' or
`.sas7bdat' extension, which should be omitted.}
  \item{tmpXport}{ string: location where temporary xport format archive should reside --
    defaults to a randomly named file in /tmp, which will be removed}
  \item{tmpProgLoc}{ string: location where temporary conversion program should reside --
    defaults to a randomly named file in /tmp, which will be removed}
  \item{sascmd}{ string: defaults to "sas"}
}
\details{
  creates a SAS program and runs it
}
\value{
  a data frame if all goes well, or NULL with warnings and some
  enduring side effects (log file for auditing)
}
\author{VJ Carey \email{<stvjc@channing.harvard.edu>}}
\note{ error handling is primitive }
\seealso{\code{\link{read.xport}}}
\examples{
## if there were some files on the web we could get a real
## runnable example
\dontrun{
R> list.files("trialdata")
 [1] "baseline.sas7bdat" "form11.sas7bdat"   "form12.sas7bdat"  
 [4] "form13.sas7bdat"   "form22.sas7bdat"   "form23.sas7bdat"  
 [7] "form3.sas7bdat"    "form4.sas7bdat"    "form48.sas7bdat"  
[10] "form50.sas7bdat"   "form51.sas7bdat"   "form71.sas7bdat"  
[13] "form72.sas7bdat"   "form8.sas7bdat"    "form9.sas7bdat"   
[16] "form90.sas7bdat"   "form91.sas7bdat"  
R> baseline<-read.ssd("trialdata","baseline")
R> form90<-read.ssd("trialdata","form90")
}
}
\keyword{file}

\eof
\name{read.xport}
\alias{read.xport}
\title{Read a SAS XPORT format library}
\description{
  Reads a file as a SAS XPORT format library and returns a list of
  data.frames.
}
\usage{
read.xport(file)
}
\arguments{
 \item{file}{character variable with the name of the file to read.  The
   file must be in SAS XPORT format.}
}
\value{
  A list with one component for each dataset in the XPORT format library.
}
\references{
  SAS Technical Support document TS-140:
  ``The Record Layout of a Data Set in SAS Transport (XPORT) Format''
  available as
  \url{http://ftp.sas.com/techsup/download/technote/ts140.html}.
}
\author{Saikat DebRoy \email{<saikat@stat.wisc.edu>}}
\seealso{
  \code{\link{read.xport}}
}
\examples{
\dontrun{
read.xport("transport")
}
}
\keyword{file}

\eof
\name{write.dta}
\alias{write.dta}
\title{Write files in Stata binary format}
\usage{
write.dta(dataframe, file, version = 6,convert.dates=TRUE, tz="GMT",
 convert.factors=c("labels","string","numeric","codes"))
}
\arguments{
  \item{dataframe}{a data frame.}
  \item{file}{character string giving filename.}
  \item{version}{Stata version: 6 and 7 are supported.}
  \item{convert.dates}{Convert \code{POSIXt} objects to Stata dates?}
  \item{tz}{timezone for date conversion}
  \item{convert.factors}{how to handle factors}
  } 
\description{
  Writes the data frame to file in the Stata version 6.0 or 7.0 binary
  format.  Does not write matrix variables.
}
\details{
 
 The major differences between Stata versions is that 7.0 allows 32-character
 variable names. The \code{abbreviate} function is used to trim long
 variables to the permitted length. A warning is given if this is needed and
 it is an error for the abbreviated names not to be unique.

  The columns in the data frame become variables in the Stata data set.
  Missing values are correctly handled.  Optionally, R date/time objects
 (\code{POSIXt} classes) are converted into the Stata format. This loses
 information -- Stata dates are in days since 1960-1-1.  \code{POSIXct}
 objects can be written without conversion but will not be understood as
 dates by Stata;  \code{POSIXlt} objects cannot be written without
 conversion.

  There are four options for handling factors. The default is to use
  Stata \code{value labels} for the factor levels.
  With \code{convert.factors="string"}, the factor levels are written as
  strings. With \code{convert.factors="numeric"} the numeric values
  of the levels are written, or \code{NA} if they cannot be coerced to
  numeric. Finally, \code{convert.factors="codes"} writes the underlying
  integer codes of the factors. This last used to be the only available
  method and is provided largely for backwards compatibility.

  For Stata 8.0 use \code{version=7} -- the only advantage of Stata 8.0
  format is that it can represent multiple different missing value
  types, and R doesn't have them.
  }
\value{
  \code{NULL}
}
\references{
  Stata 6.0 Users Manual, Stata 7.0 Programming manual, Stata 8.0 online
  help describe the file formats.
} 
\author{Thomas Lumley}
\seealso{
  \code{\link{read.dta}},
  \code{\link{attributes}},
  \code{\link{DateTimeClasses}},
  \code{\link{abbreviate}}
}
\examples{
data(swiss)
write.dta(swiss,swissfile<-tempfile())
read.dta(swissfile)
}
\keyword{file}

\eof
