/*
  ImageMagick image profile methods.
*/
#ifndef _MAGICK_PROFILE_H
#define _MAGICK_PROFILE_H

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

#include "magick/hashmap.h"
#include "magick/string_.h"

MagickExport char
  *GetNextImageProfile(const Image *);

MagickExport StringInfo
  *GetImageProfile(const Image *,const char *),
  *RemoveImageProfile(Image *,const char *);

extern MagickExport unsigned int
  CloneImageProfiles(Image *,const Image *),
  ProfileImage(Image *,const char *,const unsigned char *,const unsigned long,
    unsigned int),
  SetImageProfile(Image *,const char *,const StringInfo *);

extern MagickExport void
  DestroyImageProfiles(Image *),
  ResetImageProfileIterator(const Image *);

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif 
#endif
