/*
 * Huvudmeny fr WindowMaker.
 *
 * Syntaxen r:
 *
 * <Titel> [SHORTCUT <Genvg>] <Kommando> <Parametrar>
 *
 * <Titel> r en strng som du vill anvnda som titel i menyn. Strngen
 * mste omslutas med " om den innehller mellanslag.
 * 
 * SHORTCUT anger en genvg fr det menyalternativet. <Genvg> har likadan
 * syntax som genvgarna i filen $HOME/GNUStep/Defaults/WindowMaker.
 *
 * Man kan inte ange en genvg fr kommandona MENU och OPEN_MENU.
 * 
 * <Kommando> kan vara ett av fljande: 
 *	MENU - brjar (under)meny definition.
 *	END  - avslutar (under)meny definition.
 *	OPEN_MENU - ppnar en meny frn en fil, pipe eller innehllet av
 *		    en katalog och eventuellt freg varje med ett kommando.
 *	WORKSPACE_MENU - lgger till en undermeny med kommandon som pverkar
 *			 arbetsbordet. Endast en workspace_menu r tillten.
 *      EXEC <program> - kr ett externt program.
 *	SHEXEC <command> - executes a shell command (like gimp > /dev/null)
 *	EXIT - avslutar WindowMaker.
 *	RESTART [<fnsterhanterare>] - startar WindowMaker eller annan
 *				       fnsterhanterare.
 *	REFRESH - ritar om skrmbilden.
 *	ARRANGE_ICONS - radar upp ikonerna p skrivbordet.
 *	SHUTDOWN - ddar alla program och avslutar X-servern.
 *	SHOW_ALL - visar alla (gmda) fnster p arbetsbordet.
 *	HIDE_OTHERS - gmmer alla fnster p arbetsborder utom det som har
 *		      fokus.
 *	SAVE_SESSION - sparar utseendet p skrivbordet. Det inkluderar alla
 *		       aktiva program (storlek, position, arbetsbord, vilken
 *		       dock/clip som det startades ifrn, om det r minimerat,
 *		       skugget eller gmt. Sparar ocks det aktiva arbets-
 *		       bordet som anvndaren r p. Allting blir terstllt
 *		       vid uppstart tills nsta SAVE_SESSION eller
 *		       CLEAR_SESSION kallas. Om SaveSessionOnExit = Yes i
 *		       WindowMakers domnfil s sparas instllningarna
 *		       automatiskt vid avslut. Detta verskrider alla
 *		       SAVE_SESSION och CLEAR_SESSION (se nedan).
 *	CLEAR_SESSION - raderar tidigare sparade instllningar frn
 *			SAVE_SESSION. Har ingen effekt om SaveSessionOnExit
 *			r True.
 *	INFO - visar ruta med info.
 *
 * OPEN_MENU syntax:
 *   1. Filmenyhantering.
 *	// ppnar fil.meny, som mste innehlla en giltig menyfil, och lser
 *	// in innehllet p nuvarande positionen.
 *	OPEN_MENU fil.meny
 *   2. Pipe-menyhantering.
 *	// ppnar kommando och anvnder dess stdout fr att konstruera
 *	// menyn. Kommandots utdata mste vara giltig menysyntax. Mellan-
 *	// slaget mellan '|' och sjlva kommandot r frivilligt.
 *	OPEN_MENU | kommando
 *   3. Kataloghantering.
 *	// ppnar en eller flera kataloger och konstruerar en meny med
 *	// alla underkataloger och krbara filer i dom sorterade
 *	// alfabetiskt.
 *	OPEN_MENU /en/katalog [/en/annan/katalog ...]
 *   4. Kataloghantering med program.
 *	// ppnar en eller flera kataloger och konstruerar en meny med
 *	// alla underkataloger och krbara filer sorterade alfabetiskt.
 *	// Placerar kommando fr var och en.
 *	OPEN_MENU /en/katalog [/en/annan/katalog ...] WITH kommando -argument
 *
 *
 * <Parametrar> r programmet som skall startas.
 *
 * ** Alternativ fr kommandoraden i EXEC:
 * %s - byt ut mot den aktiva markeringen.
 * %a(meddelande) - ppnar ett svarsfnster med meddelandet och stter in
 *		    din inskrivna text.
 * %w - byt ut mot XID fr fnstret som har fokus.
 *
 * Du kan anvnda '\' fr att anvnda specialtecken (som % och ") som vanliga
 * bokstver, till exempel:
 *    xterm -T "\"Hall vrlden\""
 *
 * Du kan ocks anvnda C-liknande specialsekvenser, t ex \n.
 *
 * Varje MENU-uttryck mste ha ett matchande END-uttryck p slutet.
 *
 * Exempel:
 *
 * "Test" MENU
 *	"XTerm" EXEC xterm
 *		// skapar en undermeny med innehllet i /usr/openwin/bin
 *	"XView apps" OPEN_MENU "/usr/openwin/bin"
 *		// ngra X11-program i olika kataloger
 *	"X11 apps" OPEN_MENU /usr/X11/bin $HOME/bin/X11
 *		// stt en bakgrundsbild
 *	"Background" OPEN_MENU $HOME/images /usr/share/images WITH wmsetbg -u -t
 *		// infogar style.menu hr
 *	"Style" OPEN_MENU style.menu
 * "Test" END
 */

#include "wmmacros"

"Program" MENU
	"Info" MENU
		"Informationsruta..." INFO_PANEL
		"Licens..." LEGAL_PANEL
		"Systemkonsoll" EXEC xconsole
		"Systembelastning" SHEXEC xosview || xload
		"Processlista" EXEC xterm -e top
		"Manuallsare" EXEC xman
	"Info" END
	"XTerm" EXEC xterm -sb 
	"Rxvt (fixed)" EXEC rxvt -bg black -fg white -fn fixed
	"Rxvt (9x15)" EXEC rxvt -bg black -fg white -fn 9x15
	"Arbetsbord" WORKSPACE_MENU
	"Program" MENU
		"Grafik" MENU
			"Gimp" SHEXEC gimp >/dev/null
			"XV" EXEC xv
			"XPaint" EXEC xpaint
			"XFig" EXEC xfig
		"Grafik" END
		"X Filhanterare" EXEC xfm
		"OffiX Files" EXEC files
		"LyX" EXEC lyx
		"Netscape" EXEC netscape 
  		"Ghostview" EXEC ghostview %a(Enter file to view)
		"Acrobat" EXEC /usr/local/Acrobat3/bin/acroread %a(Skriv in PDF-fil som ska visas)
  		"TkDesk" EXEC tkdesk
	"Program" END
	"Textredigerare" MENU
		"XFte" EXEC xfte
		"XEmacs" SHEXEC xemacs || emacs
		"XJed" EXEC xjed 
		"NEdit" EXEC nedit
		"Xedit" EXEC xedit
		"VI" EXEC xterm -e vi
	"Textredigerare" END
	"Diverse" MENU
		"Xmcd" SHEXEC xmcd 2> /dev/null
		"Xplaycd" EXEC xplaycd
		"Xmixer" EXEC xmixer
	"Diverse" END
	"Verktyg" MENU
		"Minirknare" EXEC xcalc
		"Window Properties" SHEXEC xprop | xmessage -center -title 'xprop' -file -
		"Fontvljare" EXEC xfontsel
		"Terminalemulator" EXEC xminicom
		"Frstora" EXEC xmag
		"Frgkarta" EXEC xcmap
		"XKill" EXEC xkill
		"ASClock" EXEC asclock -shape
		"Klipphanterare" EXEC xclipboard
	"Verktyg" END

	"Markering" MENU
		"Kopiera" SHEXEC echo '%s' | wxcopy
		"Skicka e-mail" EXEC xterm -name mail -T "Pine" -e pine %s
		"G till webbsida" EXEC netscape %s
		"Sk i manualer" SHEXEC MANUAL_SEARCH(%s)
	"Markering" END

	"Arbetsbord" MENU
		"Gm andra" HIDE_OTHERS
		"Visa alla" SHOW_ALL
		"Rada upp ikoner" ARRANGE_ICONS
		"Uppdatera skrmen" REFRESH
		"Ls" EXEC xlock -allowroot -usefirst
		"Spara arbetsbord" SAVE_SESSION
		"Rensa sparat arbetsbord" CLEAR_SESSION
	"Arbetsbord" END

	"Utseende" MENU
		"Teman" OPEN_MENU -noext THEMES_DIR $HOME/GNUstep/Library/WindowMaker/Themes WITH setstyle
		"Stilar" OPEN_MENU -noext STYLES_DIR $HOME/GNUstep/Library/WindowMaker/Styles WITH setstyle
		"Ikonuppsttningar" OPEN_MENU -noext ICON_SETS_DIR $HOME/GNUstep/Library/WindowMaker/IconSets WITH seticons
		"Bakgrund" MENU
			"Enfrgat" MENU
                        	"Svart" WS_BACK '(solid, black)'
                        	"Bl"  WS_BACK '(solid, "#505075")'
				"Indigo" WS_BACK '(solid, "#243e6c")'
				"Mrkbl" WS_BACK '(solid, "#224477")'
                        	"Lila" WS_BACK '(solid, "#554466")'
                        	"Vete"  WS_BACK '(solid, "wheat4")'
                        	"Mrkgr"  WS_BACK '(solid, "#333340")'
                        	"Vin" WS_BACK '(solid, "#400020")'
			"Enfrgat" END
			"Toningar" MENU
				"Flagga" WS_BACK '(mdgradient, green, red, white, green)'
				"Himmel" WS_BACK '(vgradient, blue4, white)'
			"Toningar" END
			"Bilder" OPEN_MENU -noext BACKGROUNDS_DIR $HOME/GNUstep/Library/WindowMaker/Backgrounds WITH wmsetbg -u -t
		"Bakgrund" END
		"Spara tema" SHEXEC getstyle -t $HOME/GNUstep/Library/WindowMaker/Themes/"%a(Theme name)"
		"Spara ikonuppsttning" SHEXEC geticonset $HOME/GNUstep/Library/WindowMaker/IconSets/"%a(IconSet name)"
	"Utseende" END

	"Avsluta"	MENU
		"Starta om" RESTART
		"Starta AfterStep" RESTART afterstep
		"Avsluta..."  EXIT
		"Avsluta session..." SHUTDOWN
	"Avsluta" END
"Program" END
