#
# Copyright (C) 2004 Tenable Network Security
#
if(description)
{
 script_id(12076);
 script_version("$Revision: 1.4 $");

 name["english"] = "Trillian remote Overflow";

 script_name(english:name["english"]);
 
 desc["english"] = "
Trillian is a Peer2Peer client that allows users to chat and share files
with other users across the world.  A bug has been reported in the AOL 
Instant Messenger (AIM) portion of Trillian.  A remote attacker, exploiting
this flaw, would be potentially able to execute code on the client system
running Trillian.

Solution: Upgrade to Trillian 0.74 patch G (or higher)

See also: http://security.e-matters.de/advisories/022004.html
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Determines the version of Trillian.exe";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Windows";
 script_family(english:family["english"]);
 
 script_dependencies("netbios_name_get.nasl",
 		     "smb_login.nasl","smb_registry_access.nasl");
 script_require_keys("SMB/name", "SMB/login", "SMB/password",
		     "SMB/WindowsVersion",
		     "SMB/registry_access");

 script_require_ports(139, 445);
 exit(0);
}


include("smb_nt.inc");

# reg value = "C:\Program Files\Trillian\trillian.exe -command="%1"   "

rootfile = registry_get_sz(key:"SOFTWARE\Classes\AIM\shell\open\command", item:"Default");
if(!rootfile)
{
 exit(0);
}
else
{
 share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:rootfile);
 findash = strstr(rootfile, "-command");
 file = rootfile - findash;
}


#display(string(share, "\n", file, "\n"));
#exit(0);



name 	=  kb_smb_name();
login	=  kb_smb_login();
pass  	=  kb_smb_password();
domain 	=  kb_smb_domain();
port    =  kb_smb_transport();
if(!port) port = 139;



if(!get_port_state(port))exit(0);

soc = open_sock_tcp(port);
if(!soc)exit(0);



r = smb_session_request(soc:soc, remote:name);
if(!r)exit(0);

prot = smb_neg_prot(soc:soc);
if(!prot)exit(0);

r = smb_session_setup(soc:soc, login:login, password:pass, domain:domain, prot:prot);
if(!r)exit(0);

uid = session_extract_uid(reply:r);



r = smb_tconx(soc:soc, name:name, uid:uid, share:share);
tid = tconx_extract_tid(reply:r);
if(!tid)exit(0);

fid = OpenAndX(socket:soc, uid:uid, tid:tid, file:file);
if(!fid)exit(0);

fsize = smb_get_file_size(socket:soc, uid:uid, tid:tid, fid:fid);
if (!fsize) exit(0);


# C:\Program Files\Trillian>find /N /i "v0.7" trillian.exe
#
#---------- TRILLIAN.EXE
#[31288]v0.74 (w/ Patch G) - February 2004

off = 31200;
data = ReadAndX(socket:soc, uid:uid, tid:tid, count:512, off:off);
data = str_replace(find:raw_string(0), replace:"", string:data);

version = strstr(data, "v0.7");
if(!version)exit(0);
hopup = version + 25;
v = version - hopup;
set_kb_item(name:"Host/Windows/Trillian/Version", value:v);
if (egrep(string:v, pattern:"v0\.7[1-4].*")) {
    if (! egrep(string:v, pattern:"\(w/ Patch [G-Z]\)")) security_hole(port);
}

exit(0);
