#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(13388);
 script_version ("$Revision: 1.5 $");
 script_bugtraq_id(6683, 7184, 7185);
 script_cve_id("CAN-2003-0072", "CAN-2003-0082", "CAN-2003-0058");
 name["english"] = "Solaris 8 (sparc) : 112390-09";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing Sun Security Patch number 112390-09
( Supplemental Encryption Kerberos V5: mech_krb5.so.1 patch).

You should install this patch for your system to be up-to-date.

Solution : http://sunsolve.sun.com/search/document.do?assetkey=1-21-112390-09-1
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for patch 112390-09"; 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Solaris Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Solaris/showrev");
 exit(0);
}



include("solaris.inc");

e =  solaris_check_patch(release:"5.8", arch:"sparc", patch:"112390-09", obsoleted_by:"109223-02", package:"SUNWk5pk SUNWk5pkx SUNWk5pu SUNWk5pux");

if ( e < 0 ) security_hole(0);
else if ( e > 0 )
{
	set_kb_item(name:"CAN-2003-0072", value:TRUE);
	set_kb_item(name:"CAN-2003-0082", value:TRUE);
	set_kb_item(name:"CAN-2003-0058", value:TRUE);
	set_kb_item(name:"BID-6683", value:TRUE);
	set_kb_item(name:"BID-7184", value:TRUE);
	set_kb_item(name:"BID-7185", value:TRUE);
}
