#
# (C) Tenable Network Security
#

if (description)
{
	script_id(14641);
	script_bugtraq_id(10871, 11091, 11100, 11099, 11120);
 	script_cve_id("CAN-2004-0637", "CAN-2004-0638");
 	if ( defined_func("script_xref") ) script_xref(name:"IAVA", value:"2004-A-0014");

 	script_version ("$Revision: 1.4 $");
	script_name(english: "Oracle DBS_SCHEDULER vulnerability");
	script_description(english:"
The remote Oracle Database, according to its version number,
is vulnerable to a remote command execution vulnerability which may allow
an attacker who can execute SQL statements with certain privileges to
execute arbitrary commands on the remote host.

Solution : http://www.oracle.com/technology/deploy/security/pdf/2004alert68.pdf
Risk Factor : High");

	script_summary(english: "Checks the version of the remote Database");

	script_category(ACT_GATHER_INFO);
	script_family(english: "Gain a shell remotely");
	script_copyright(english: "This script is (C) 2004 Tenable Network Security");
	script_dependencie("oracle_tnslsnr_version.nasl");
	script_require_ports(1521, 1541);
	exit(0);
}


port = 1521;
version = get_kb_item("oracle_tnslsnr/1521/version");
if(!version){version = get_kb_item("oracle_tnslsnr/1541/version"); port = 1541; }
if(!version)exit(0);

if(ereg(pattern:".*Version ([0-8]\..*|9\.(0\.([0-3]\.|4\.[01]))|9\.2\..*|10\.(0\..*|1\.0\.[0-2]([^0-9]|$)))", string:version))
	security_hole(port);
