#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(15507);
 script_bugtraq_id(11312);
 script_version ("$Revision: 1.1 $");
 name["english"] = "FreeBSD Ports : xerces-c2 < 2.6.0";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has the following package installed :
	xerces-c2 < 2.6.0

xerces-c2 is a validating XML parser.

The remote version of this software is vulnerable to a denial of service
attack in the way it parses XML attributes which may result in an
infinite loop.

Solution : http://www.vuxml.org/freebsd/76301302-1d59-11d9-814e-0001020eed82.html
Risk factor : Low";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the xerces-c2 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
if ( ! pkgs ) exit(0);

package = egrep(pattern:"^xerces-c2-2", string:pkgs);
if (package && pkg_cmp(pkg:package, reference:"xerces-c2-2.6.0") < 0 )
	security_warning(0);
